/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IDeltaManager.java,v 1.4 2005/02/16 22:21:27 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 * 
 * $Id: IDeltaManager.java,v 1.4 2005/02/16 22:21:27 qiyanli Exp $
 **********************************************************************/
package org.eclipse.hyades.loaders.trace;


/**
 * @author slavescu
 */
public interface IDeltaManager {
	/**
	 * take a snapshot, replaces the previous one
	 */
	public void takeSnapshot();
	/**
	 * returns the current snapshot 
	 */
	public ISnapshot retrieveSnapshot();
	/**
	 * returns the current snapshot 
	 */
	public void removeSnapshot();
	/**
	 * returns: 
	 * 		-1 no snapshot exists
	 * 		1 snapshot exists
	 */
	public int computeDelta(IDelta delta);
	public int computeDelta(IDelta delta,int featureID);
}
