/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: XMLmethodCallLoader.java,v 1.8 2005/03/18 22:42:07 slavescu Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 * 
 * $Id: XMLmethodCallLoader.java,v 1.8 2005/03/18 22:42:07 slavescu Exp $
 **********************************************************************/
package org.eclipse.hyades.loaders.trace;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.models.trace.TRCCallerCalleeInvocationInfo;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;
import org.eclipse.hyades.models.trace.TraceFactory;
import org.eclipse.hyades.models.trace.TracePackage;
import org.eclipse.hyades.models.trace.impl.TRCFullTraceObjectImpl;
/**
 * @author slavescu
 *  
 */
public class XMLmethodCallLoader extends TraceMethodBaseLoader {
	//~ Static fields/initializers
	// -----------------------------------------------------------------
	//    private static final String THREAD_ID_REF = "threadIdRef";

	//	protected static final String TICKET = "ticket";
	//	protected static final String STACK_DEPTH = "stackDepth";
	private static final Object REMOTE_INVOCATION_RESOLUTION_LOCK = new Object();

	public void addYourselfInContext() {
		if (!loadToModel) {
			return;
		}
		if(context.isFilterOn())
		{
			if(context.getFilterEngine().isFiltered(TracePackage.eINSTANCE.getTRCMethod_Name(),LoadersUtils.getLookUpKey(methodIdRef)))
			{
				return;
			}
		}
		
		if(remoteInvocationContext)
			activeInvocationContext=true;
		theProcess = getProcess();
		theThread = getThreadByIdRef(theProcess);
		Object csKey = LoadersUtils.getLookUpKey(threadIdRef);
		cs = (CallStackPerThread) LookupServiceExtensions.getInstance().locate(context, CallStackPerThread.class, csKey);
		if (cs == null) {
			cs = new CallStackPerThread();
			LoadersUtils.registerGenericLookUpEntry(context, csKey, cs);
		}
		invocationPool = cs.invocationPool;
		dispatchProcessMode(ProcessSteps.ALL);
		setMaxStackDepth(theThread);
	}
	public void cleanUp(HierarchyContext context) {
		LookupServiceExtensions.getInstance().deregister(context, CallStackPerThread.class);
		super.cleanUp();
	}
	public void endChild(String name) {
	}
	public void initialize(HierarchyContext context, String name) {
		loadToModel = context.isLoadToModel();
		if (!loadToModel) {
			return;
		}
		super.initialize(context, name);
		fullInvoker = null;
	}
	public void startChild(String name) {
		if (!loadToModel) {
			return;
		}
		if (name.equals(INVOCATION_CONTEXT)) {
			setNullInvocationContext();
			activeInvocationContext = true;
		} else
			super.startChild(name);
	}

	/**
	 *  
	 */
	protected void processEF(int step) {
		super.processEF(step);
		theClass = getClassByIdRef(theThread, TRCFullTraceObjectImpl.class, 0);
		theMethod = getMethodByIdRef(theClass);
		if (objIdRef > 0) {
			theObject = getObjectByIdRef(objIdRef, TRCFullTraceObjectImpl.class);
		} else {
			theObject = getClassObject(theMethod.getDefiningClass(), TRCFullTraceObjectImpl.class);
		}
		if (theObject == null) {
			theObject = TraceFactory.eINSTANCE.createTRCFullTraceObject();
		}
		/* Create the method invocation element */
		fullInvocation = TraceFactory.eINSTANCE.createTRCCallerCalleeInvocationInfo();
		fullInvocation.setStackDepth(stackDepth);
		((TRCCallerCalleeInvocationInfo)fullInvocation).setCallTime(createDeltaTime());
		fullInvocation.setTicket(ticket);
		fullInvocation.setMethod(theMethod);
		fullInvocation.setThread(theThread);
		fullInvocation.setProcess(theProcess);
		fullInvocation.setOwningObject((TRCFullTraceObject) theObject);
        
		addInputOutputValues();
        
		synchronized (REMOTE_INVOCATION_RESOLUTION_LOCK) {
			setInvokerMethod(theThread, fullInvocation);
			updateForwardInvokes(fullInvocation);
		}
		if (cs.isEmpty()) {
			theThread.getInitialInvocations().add(fullInvocation);
		}
//		updateStatisticalInfo(theThread, fullInvoker, fullInvocation, theMethod, (TRCFullTraceObject) theObject, theClass);
		cs.push(invocationPool.allocInvocation(fullInvocation, cs));
		//        LookupServiceExtensions.getInstance().register(context,
		// fullInvocation);
	}
	/**
	 *  
	 */
	protected void processES(int step) {
		super.processES(step);
		theClass = getClassByIdRef(theThread, TRCFullTraceObjectImpl.class, 0);
		theMethod = getMethodByIdRef(theClass);
		if (objIdRef > 0) {
			virtualObject = (VirtualObjectInfo) LookupServiceExtensions.getInstance().locate(context, VirtualObjectInfo.class, LoadersUtils.getLookUpKey(objIdRef));
			if (virtualObject != null) {
				theObject = getClassObject(virtualObject.myClass, TRCFullTraceObjectImpl.class);
			} else {
				return;
			}
		} else {
			theObject = getClassObject(theClass, TRCFullTraceObjectImpl.class);
		}
//		updateStatisticalInfoOnly(theMethod, (TRCFullTraceObject) theObject, theClass, theThread, createDeltaTime());
	}
}