/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: XMLmonStillOwnedLoader.java,v 1.2 2005/03/18 22:42:07 slavescu Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 * 
 * $Id: XMLmonStillOwnedLoader.java,v 1.2 2005/03/18 22:42:07 slavescu Exp $
 **********************************************************************/
package org.eclipse.hyades.loaders.trace;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.hyades.loaders.hierarchy.Constants;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;
import org.eclipse.hyades.models.trace.TRCHeapObject;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TracePackage;
import org.eclipse.hyades.models.trace.impl.TRCFullHeapObjectImpl;
import org.eclipse.hyades.models.trace.impl.TRCFullTraceObjectImpl;
import org.eclipse.hyades.models.trace.impl.TRCHeapObjectImpl;
public class XMLmonStillOwnedLoader extends TraceXMLFragmentLoader {
	//~ Static fields/initializers
	// -----------------------------------------------------------------
	//~ Instance fields
	// ----------------------------------------------------------------------------
	protected static HashMap processesMap;
	//~ Methods
	// ------------------------------------------------------------------------------------
	public void addYourselfInContext() {
		if(context.isFilterOn())
		{
			if(context.getFilterEngine().isFiltered(TracePackage.eINSTANCE.getTRCThread_Name(),LoadersUtils.getLookUpKey(threadIdRef)))
			{
				return;
			}
		}
		theProcess = getProcess();
		theThread = getThreadByIdRef(theProcess);
		dispatchProcessMode(ProcessSteps.ALL);
		TRCThread ownerThread = theThread;
		TRCObject lockObject  = theObject;
		
		//lock still locked should be memorized beside thread and process
		if( processesMap==null ) {
		  processesMap = new HashMap();
		}
		HashMap mp = (HashMap)processesMap.get( theProcess );
		if( mp==null )
		{
		  mp = new HashMap();
		  processesMap.put( theProcess, mp );
		}
		ArrayList mso = (ArrayList)mp.get( ownerThread );
		if( mso==null )
		{
		  mso = new ArrayList();
		  mp.put( ownerThread, mso );
		}
		
		mso.add( lockObject );
	}	
	public static ArrayList getStillLocked( TRCProcess process, TRCThread thread )
	{
	  if( processesMap== null ) return null;
	  HashMap mp = (HashMap)processesMap.get( process );
	  if( mp==null ) return null;
	  return (ArrayList)mp.remove( thread );
	}
	public void initialize(HierarchyContext context, String name) {
		loadToModel = context.isLoadToModel();
		super.initialize(context, name);
	}
	public void cleanUp() {
       super.cleanUp();
       processesMap = null;
    }
	protected void processEF(int step) {
		super.processEF(step);
		if ((theObject == null) || !(theObject instanceof TRCFullTraceObject)) {
			theObject = (TRCFullTraceObject) LookupServiceExtensions.getInstance().locate(context, TRCFullTraceObjectImpl.class, LoadersUtils.getLookUpKey(objIdRef));
		}
	}
	protected void processES(int step) {
		super.processES(step);
		if (objIdRef > 0) {
			virtualObject = (VirtualObjectInfo) LookupServiceExtensions.getInstance().locate(context, VirtualObjectInfo.class, LoadersUtils.getLookUpKey(objIdRef));
			if (virtualObject != null) {
				theObject = getClassObject(virtualObject.myClass, TRCFullTraceObjectImpl.class);
			} else {
				return;
			}
		} else {
			theObject = getClassObject(theClass, TRCFullTraceObjectImpl.class);
		}
	}
	protected void processHF(int step) {
		super.processHF(step);
		Class clazz = (TraceUtils.isBooleanOptionEnabled(context,Constants.MULTIPLE_HEAP_DUMPS) ? TRCFullHeapObjectImpl.class : TRCHeapObjectImpl.class);
		if ((theObject == null) || !(theObject instanceof TRCHeapObject)) {
			theObject = (TRCHeapObject) LookupServiceExtensions.getInstance().locate(context, clazz, LoadersUtils.getLookUpKey(objIdRef));
		}
	}
}
