/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: XMLthreadEndLoader.java,v 1.9 2005/03/18 22:42:07 slavescu Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 * 
 * $Id: XMLthreadEndLoader.java,v 1.9 2005/03/18 22:42:07 slavescu Exp $
 **********************************************************************/
package org.eclipse.hyades.loaders.trace;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCThreadDeadEvent;
import org.eclipse.hyades.models.trace.TraceFactory;
import org.eclipse.hyades.models.trace.TracePackage;
import org.eclipse.hyades.models.trace.impl.TRCThreadImpl;
/**
 * @author slavescu
 *  
 */
public class XMLthreadEndLoader extends TraceXMLFragmentLoader {
	//~ Methods
	// ------------------------------------------------------------------------------------
	public void addYourselfInContext() {
		if(context.isFilterOn())
		{
			if(context.getFilterEngine().isFiltered(TracePackage.eINSTANCE.getTRCThread_Name(),LoadersUtils.getLookUpKey(threadIdRef)))
			{
				return;
			}
		}
		TRCProcess p = getProcess();
		TRCThread thread = (TRCThread) LookupServiceExtensions.getInstance().locate(context, TRCThreadImpl.class, LoadersUtils.getLookUpKey(threadIdRef));
		if (thread != null) {
			thread.setStopTime(createDeltaTime());
			TRCThreadDeadEvent event = TraceFactory.eINSTANCE.createTRCThreadDeadEvent();
			event.setTime(thread.getStopTime());
			thread.getThreadEvents().add(event);
		}
	}
	public void initialize(HierarchyContext context, String name) {
		super.initialize(context, name);
	}
}