/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TRCLineCoverageData.java,v 1.10 2005/02/10 22:13:41 qiyanli Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.trace;

import org.eclipse.hyades.models.trace.util.LLUnitData;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>TRC Line Coverage Data</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * Aims to actually contain hit or count coverage data.
 * WARNING: Should not be used directly, but rather querying TRCLLData.getUnitData().
 * To be interpreted thanks to LLUnitData that will contain as a result of the query everything useful without wondering which kind of line level data has been collected.
 * One of hitTable and countTable is supposed to be null.
 * This way some place is saved.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCLineCoverageData#getLineTable <em>Line Table</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCLineCoverageData#getHitTable <em>Hit Table</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCLineCoverageData#getCountTable <em>Count Table</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCLineCoverageData#getSourceInfo <em>Source Info</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCLineCoverageData()
 * @model 
 * @generated
 */
public interface TRCLineCoverageData extends TRCLLData{
	/**
	 * Returns the value of the '<em><b>Line Table</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Line Table</em>' attribute list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Line Table</em>' attribute.
	 * @see #setLineTable(int[])
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCLineCoverageData_LineTable()
	 * @model dataType="org.eclipse.hyades.models.hierarchy.IntArray"
	 * @generated
	 */
	int[] getLineTable();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCLineCoverageData#getLineTable <em>Line Table</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Line Table</em>' attribute.
	 * @see #getLineTable()
	 * @generated
	 */
	void setLineTable(int[] value);

	/**
	 * Returns the value of the '<em><b>Hit Table</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Hit Table</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Hit Table</em>' attribute.
	 * @see #setHitTable(boolean[])
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCLineCoverageData_HitTable()
	 * @model dataType="org.eclipse.hyades.models.hierarchy.BooleanArray"
	 * @generated
	 */
	boolean[] getHitTable();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCLineCoverageData#getHitTable <em>Hit Table</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Hit Table</em>' attribute.
	 * @see #getHitTable()
	 * @generated
	 */
	void setHitTable(boolean[] value);

	/**
	 * Returns the value of the '<em><b>Count Table</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Count Table</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Count Table</em>' attribute.
	 * @see #setCountTable(int[])
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCLineCoverageData_CountTable()
	 * @model dataType="org.eclipse.hyades.models.hierarchy.IntArray"
	 * @generated
	 */
	int[] getCountTable();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCLineCoverageData#getCountTable <em>Count Table</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Count Table</em>' attribute.
	 * @see #getCountTable()
	 * @generated
	 */
	void setCountTable(int[] value);

	/**
	 * Returns the value of the '<em><b>Source Info</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Source Info</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Source Info</em>' reference.
	 * @see #setSourceInfo(TRCSourceInfoWithLLData)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCLineCoverageData_SourceInfo()
	 * @model 
	 * @generated
	 */
	TRCSourceInfoWithLLData getSourceInfo();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCLineCoverageData#getSourceInfo <em>Source Info</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Source Info</em>' reference.
	 * @see #getSourceInfo()
	 * @generated
	 */
	void setSourceInfo(TRCSourceInfoWithLLData value);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Returns the number of LLUnits for which detailed information is available. If this returns zero, only the summary information is available.
	 * 
	 * <!-- end-model-doc -->
	 * @model parameters=""
	 * @generated
	 */
	int getUnitCount();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Returns an LLUnitData object with detailed information about the indicated unit_number. If instance is not null, then that instance is re-used (overwriting its fields with new data) and returned. Reusing the object instance saves construction time and heap traffic. See below for restrictions on re-using an LLUnitData instance. Unit numbers range from zero to getUnitCount()-1.
	 * 
	 * <!-- end-model-doc -->
	 * @model dataType="org.eclipse.hyades.models.trace.LLUnitData" parameters="org.eclipse.emf.ecore.EInt org.eclipse.hyades.models.trace.LLUnitData"
	 * @generated
	 */
	LLUnitData getUnitData(int unitNumber, LLUnitData instance);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Returns true if count information is filled in, i.e. countTable is not null
	 * <!-- end-model-doc -->
	 * @model 
	 * @generated
	 */
	boolean hasCountInfo();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Returns false
	 * <!-- end-model-doc -->
	 * @model 
	 * @generated
	 */
	boolean hasAccumulatedTimeInfo();

} // TRCLineCoverageData
