/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TRCAggregatedMethodInvocationImpl.java,v 1.10 2005/02/10 22:13:41 qiyanli Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.trace.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.trace.TRCAggregatedMethodInvocation;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCTraceObject;
import org.eclipse.hyades.models.trace.TracePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TRC Aggregated Method Invocation</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCAggregatedMethodInvocationImpl#getCount <em>Count</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCAggregatedMethodInvocationImpl#getBaseTime <em>Base Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCAggregatedMethodInvocationImpl#getCumulativeTime <em>Cumulative Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCAggregatedMethodInvocationImpl#getMinTime <em>Min Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCAggregatedMethodInvocationImpl#getMaxTime <em>Max Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCAggregatedMethodInvocationImpl#getCallerLineNo <em>Caller Line No</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCAggregatedMethodInvocationImpl#getTotalCpuTime <em>Total Cpu Time</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TRCAggregatedMethodInvocationImpl extends TRCMethodInvocationImpl implements TRCAggregatedMethodInvocation {
	/**
	 * The default value of the '{@link #getCount() <em>Count</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCount()
	 * @generated
	 * @ordered
	 */
	protected static final int COUNT_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getCount() <em>Count</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCount()
	 * @generated
	 * @ordered
	 */
	protected int count = COUNT_EDEFAULT;

	/**
	 * The default value of the '{@link #getBaseTime() <em>Base Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getBaseTime()
	 * @generated
	 * @ordered
	 */
	protected static final double BASE_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getBaseTime() <em>Base Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getBaseTime()
	 * @generated
	 * @ordered
	 */
	protected double baseTime = BASE_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getCumulativeTime() <em>Cumulative Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCumulativeTime()
	 * @generated
	 * @ordered
	 */
	protected static final double CUMULATIVE_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getCumulativeTime() <em>Cumulative Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCumulativeTime()
	 * @generated
	 * @ordered
	 */
	protected double cumulativeTime = CUMULATIVE_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getMinTime() <em>Min Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMinTime()
	 * @generated
	 * @ordered
	 */
	protected static final double MIN_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getMinTime() <em>Min Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMinTime()
	 * @generated
	 * @ordered
	 */
	protected double minTime = MIN_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getMaxTime() <em>Max Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMaxTime()
	 * @generated
	 * @ordered
	 */
	protected static final double MAX_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getMaxTime() <em>Max Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMaxTime()
	 * @generated
	 * @ordered
	 */
	protected double maxTime = MAX_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getCallerLineNo() <em>Caller Line No</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCallerLineNo()
	 * @generated
	 * @ordered
	 */
	protected static final int CALLER_LINE_NO_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getCallerLineNo() <em>Caller Line No</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCallerLineNo()
	 * @generated
	 * @ordered
	 */
	protected int callerLineNo = CALLER_LINE_NO_EDEFAULT;

	/**
	 * The default value of the '{@link #getTotalCpuTime() <em>Total Cpu Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTotalCpuTime()
	 * @generated
	 * @ordered
	 */
	protected static final double TOTAL_CPU_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getTotalCpuTime() <em>Total Cpu Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTotalCpuTime()
	 * @generated
	 * @ordered
	 */
	protected double totalCpuTime = TOTAL_CPU_TIME_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TRCAggregatedMethodInvocationImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return TracePackage.eINSTANCE.getTRCAggregatedMethodInvocation();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getCount() {
		return count;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCount(int newCount) {
		int oldCount = count;
		count = newCount;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__COUNT, oldCount, count));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getBaseTime() {
		return baseTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setBaseTime(double newBaseTime) {
		double oldBaseTime = baseTime;
		baseTime = newBaseTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__BASE_TIME, oldBaseTime, baseTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getCumulativeTime() {
		return cumulativeTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCumulativeTime(double newCumulativeTime) {
		double oldCumulativeTime = cumulativeTime;
		cumulativeTime = newCumulativeTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__CUMULATIVE_TIME, oldCumulativeTime, cumulativeTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getMinTime() {
		return minTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setMinTime(double newMinTime) {
		double oldMinTime = minTime;
		minTime = newMinTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__MIN_TIME, oldMinTime, minTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getMaxTime() {
		return maxTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setMaxTime(double newMaxTime) {
		double oldMaxTime = maxTime;
		maxTime = newMaxTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__MAX_TIME, oldMaxTime, maxTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getCallerLineNo() {
		return callerLineNo;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCallerLineNo(int newCallerLineNo) {
		int oldCallerLineNo = callerLineNo;
		callerLineNo = newCallerLineNo;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__CALLER_LINE_NO, oldCallerLineNo, callerLineNo));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getTotalCpuTime() {
		return totalCpuTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTotalCpuTime(double newTotalCpuTime) {
		double oldTotalCpuTime = totalCpuTime;
		totalCpuTime = newTotalCpuTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__TOTAL_CPU_TIME, oldTotalCpuTime, totalCpuTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__METHOD:
					if (method != null)
						msgs = ((InternalEObject)method).eInverseRemove(this, TracePackage.TRC_METHOD__INVOCATIONS, TRCMethod.class, msgs);
					return basicSetMethod((TRCMethod)otherEnd, msgs);
				case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__INVOKED_BY:
					if (invokedBy != null)
						msgs = ((InternalEObject)invokedBy).eInverseRemove(this, TracePackage.TRC_METHOD_INVOCATION__INVOKES, TRCMethodInvocation.class, msgs);
					return basicSetInvokedBy((TRCMethodInvocation)otherEnd, msgs);
				case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__INVOKES:
					return ((InternalEList)getInvokes()).basicAdd(otherEnd, msgs);
				case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__PROCESS:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__PROCESS, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__METHOD:
					return basicSetMethod(null, msgs);
				case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__INVOKED_BY:
					return basicSetInvokedBy(null, msgs);
				case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__INVOKES:
					return ((InternalEList)getInvokes()).basicRemove(otherEnd, msgs);
				case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__PROCESS:
					return eBasicSetContainer(null, TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__PROCESS, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__PROCESS:
					return ((InternalEObject)eContainer).eInverseRemove(this, TracePackage.TRC_PROCESS__INVOCATIONS, TRCProcess.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__METHOD:
				if (resolve) return getMethod();
				return basicGetMethod();
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__INVOKED_BY:
				if (resolve) return getInvokedBy();
				return basicGetInvokedBy();
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__INVOKES:
				return getInvokes();
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__THREAD:
				if (resolve) return getThread();
				return basicGetThread();
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__PROCESS:
				return getProcess();
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__OWNING_OBJECT:
				if (resolve) return getOwningObject();
				return basicGetOwningObject();
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__COUNT:
				return new Integer(getCount());
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__BASE_TIME:
				return new Double(getBaseTime());
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__CUMULATIVE_TIME:
				return new Double(getCumulativeTime());
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__MIN_TIME:
				return new Double(getMinTime());
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__MAX_TIME:
				return new Double(getMaxTime());
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__CALLER_LINE_NO:
				return new Integer(getCallerLineNo());
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__TOTAL_CPU_TIME:
				return new Double(getTotalCpuTime());
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__METHOD:
				setMethod((TRCMethod)newValue);
				return;
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__INVOKED_BY:
				setInvokedBy((TRCMethodInvocation)newValue);
				return;
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__INVOKES:
				getInvokes().clear();
				getInvokes().addAll((Collection)newValue);
				return;
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__THREAD:
				setThread((TRCThread)newValue);
				return;
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__PROCESS:
				setProcess((TRCProcess)newValue);
				return;
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__OWNING_OBJECT:
				setOwningObject((TRCTraceObject)newValue);
				return;
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__COUNT:
				setCount(((Integer)newValue).intValue());
				return;
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__BASE_TIME:
				setBaseTime(((Double)newValue).doubleValue());
				return;
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__CUMULATIVE_TIME:
				setCumulativeTime(((Double)newValue).doubleValue());
				return;
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__MIN_TIME:
				setMinTime(((Double)newValue).doubleValue());
				return;
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__MAX_TIME:
				setMaxTime(((Double)newValue).doubleValue());
				return;
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__CALLER_LINE_NO:
				setCallerLineNo(((Integer)newValue).intValue());
				return;
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__TOTAL_CPU_TIME:
				setTotalCpuTime(((Double)newValue).doubleValue());
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__METHOD:
				setMethod((TRCMethod)null);
				return;
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__INVOKED_BY:
				setInvokedBy((TRCMethodInvocation)null);
				return;
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__INVOKES:
				getInvokes().clear();
				return;
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__THREAD:
				setThread((TRCThread)null);
				return;
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__PROCESS:
				setProcess((TRCProcess)null);
				return;
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__OWNING_OBJECT:
				setOwningObject((TRCTraceObject)null);
				return;
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__COUNT:
				setCount(COUNT_EDEFAULT);
				return;
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__BASE_TIME:
				setBaseTime(BASE_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__CUMULATIVE_TIME:
				setCumulativeTime(CUMULATIVE_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__MIN_TIME:
				setMinTime(MIN_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__MAX_TIME:
				setMaxTime(MAX_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__CALLER_LINE_NO:
				setCallerLineNo(CALLER_LINE_NO_EDEFAULT);
				return;
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__TOTAL_CPU_TIME:
				setTotalCpuTime(TOTAL_CPU_TIME_EDEFAULT);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__METHOD:
				return method != null;
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__INVOKED_BY:
				return invokedBy != null;
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__INVOKES:
				return invokes != null && !invokes.isEmpty();
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__THREAD:
				return thread != null;
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__PROCESS:
				return getProcess() != null;
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__OWNING_OBJECT:
				return owningObject != null;
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__COUNT:
				return count != COUNT_EDEFAULT;
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__BASE_TIME:
				return baseTime != BASE_TIME_EDEFAULT;
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__CUMULATIVE_TIME:
				return cumulativeTime != CUMULATIVE_TIME_EDEFAULT;
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__MIN_TIME:
				return minTime != MIN_TIME_EDEFAULT;
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__MAX_TIME:
				return maxTime != MAX_TIME_EDEFAULT;
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__CALLER_LINE_NO:
				return callerLineNo != CALLER_LINE_NO_EDEFAULT;
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION__TOTAL_CPU_TIME:
				return totalCpuTime != TOTAL_CPU_TIME_EDEFAULT;
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (count: ");
		result.append(count);
		result.append(", baseTime: ");
		result.append(baseTime);
		result.append(", cumulativeTime: ");
		result.append(cumulativeTime);
		result.append(", minTime: ");
		result.append(minTime);
		result.append(", maxTime: ");
		result.append(maxTime);
		result.append(", callerLineNo: ");
		result.append(callerLineNo);
		result.append(", totalCpuTime: ");
		result.append(totalCpuTime);
		result.append(')');
		return result.toString();
	}

} //TRCAggregatedMethodInvocationImpl
