/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TRCClassImpl.java,v 1.16 2005/03/18 13:38:35 slavescu Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.trace.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.loaders.trace.IDelta;
import org.eclipse.hyades.loaders.trace.ISnapshot;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCClassLoader;
import org.eclipse.hyades.models.trace.TRCLockAccess;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.TRCSourceInfo;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TracePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TRC Class</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCClassImpl#getId <em>Id</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCClassImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCClassImpl#getSize <em>Size</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCClassImpl#getLoadTime <em>Load Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCClassImpl#getUnloadTime <em>Unload Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCClassImpl#isInterface <em>Interface</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCClassImpl#getLineNo <em>Line No</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCClassImpl#getBaseTime <em>Base Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCClassImpl#getCumulativeTime <em>Cumulative Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCClassImpl#getCalls <em>Calls</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCClassImpl#getInheritedCalls <em>Inherited Calls</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCClassImpl#getInheritedBaseTime <em>Inherited Base Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCClassImpl#getInheritedCumulativeTime <em>Inherited Cumulative Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCClassImpl#getTotalSize <em>Total Size</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCClassImpl#getTotalInstances <em>Total Instances</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCClassImpl#getCollectedSize <em>Collected Size</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCClassImpl#getCollectedInstances <em>Collected Instances</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCClassImpl#getTotalCpuTime <em>Total Cpu Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCClassImpl#getObjects <em>Objects</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCClassImpl#getLoadedBy <em>Loaded By</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCClassImpl#getMethods <em>Methods</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCClassImpl#getClassObjects <em>Class Objects</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCClassImpl#getPackage <em>Package</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCClassImpl#getClassLoader <em>Class Loader</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCClassImpl#getSourceInfo <em>Source Info</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCClassImpl#getEnclosedBy <em>Enclosed By</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCClassImpl#getExtends <em>Extends</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCClassImpl#getImplements <em>Implements</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCClassImpl#getLocks <em>Locks</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TRCClassImpl extends EObjectImpl implements TRCClass {
	/**
	 * The default value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected static final long ID_EDEFAULT = 0L;

	/**
	 * The cached value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected long id = ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getSize() <em>Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSize()
	 * @generated
	 * @ordered
	 */
	protected static final int SIZE_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getSize() <em>Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSize()
	 * @generated
	 * @ordered
	 */
	protected int size = SIZE_EDEFAULT;

	/**
	 * The default value of the '{@link #getLoadTime() <em>Load Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLoadTime()
	 * @generated
	 * @ordered
	 */
	protected static final double LOAD_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getLoadTime() <em>Load Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLoadTime()
	 * @generated
	 * @ordered
	 */
	protected double loadTime = LOAD_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getUnloadTime() <em>Unload Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUnloadTime()
	 * @generated
	 * @ordered
	 */
	protected static final double UNLOAD_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getUnloadTime() <em>Unload Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUnloadTime()
	 * @generated
	 * @ordered
	 */
	protected double unloadTime = UNLOAD_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #isInterface() <em>Interface</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isInterface()
	 * @generated
	 * @ordered
	 */
	protected static final boolean INTERFACE_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isInterface() <em>Interface</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isInterface()
	 * @generated
	 * @ordered
	 */
	protected boolean interface_ = INTERFACE_EDEFAULT;

	/**
	 * The default value of the '{@link #getLineNo() <em>Line No</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLineNo()
	 * @generated
	 * @ordered
	 */
	protected static final int LINE_NO_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getLineNo() <em>Line No</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLineNo()
	 * @generated
	 * @ordered
	 */
	protected int lineNo = LINE_NO_EDEFAULT;

	/**
	 * The default value of the '{@link #getBaseTime() <em>Base Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getBaseTime()
	 * @generated
	 * @ordered
	 */
	protected static final double BASE_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getBaseTime() <em>Base Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getBaseTime()
	 * @generated
	 * @ordered
	 */
	protected double baseTime = BASE_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getCumulativeTime() <em>Cumulative Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCumulativeTime()
	 * @generated
	 * @ordered
	 */
	protected static final double CUMULATIVE_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getCumulativeTime() <em>Cumulative Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCumulativeTime()
	 * @generated
	 * @ordered
	 */
	protected double cumulativeTime = CUMULATIVE_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getCalls() <em>Calls</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCalls()
	 * @generated
	 * @ordered
	 */
	protected static final int CALLS_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getCalls() <em>Calls</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCalls()
	 * @generated
	 * @ordered
	 */
	protected int calls = CALLS_EDEFAULT;

	/**
	 * The default value of the '{@link #getInheritedCalls() <em>Inherited Calls</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInheritedCalls()
	 * @generated
	 * @ordered
	 */
	protected static final int INHERITED_CALLS_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getInheritedCalls() <em>Inherited Calls</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInheritedCalls()
	 * @generated
	 * @ordered
	 */
	protected int inheritedCalls = INHERITED_CALLS_EDEFAULT;

	/**
	 * The default value of the '{@link #getInheritedBaseTime() <em>Inherited Base Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInheritedBaseTime()
	 * @generated
	 * @ordered
	 */
	protected static final double INHERITED_BASE_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getInheritedBaseTime() <em>Inherited Base Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInheritedBaseTime()
	 * @generated
	 * @ordered
	 */
	protected double inheritedBaseTime = INHERITED_BASE_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getInheritedCumulativeTime() <em>Inherited Cumulative Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInheritedCumulativeTime()
	 * @generated
	 * @ordered
	 */
	protected static final double INHERITED_CUMULATIVE_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getInheritedCumulativeTime() <em>Inherited Cumulative Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInheritedCumulativeTime()
	 * @generated
	 * @ordered
	 */
	protected double inheritedCumulativeTime = INHERITED_CUMULATIVE_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getTotalSize() <em>Total Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTotalSize()
	 * @generated
	 * @ordered
	 */
	protected static final int TOTAL_SIZE_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getTotalSize() <em>Total Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTotalSize()
	 * @generated
	 * @ordered
	 */
	protected int totalSize = TOTAL_SIZE_EDEFAULT;
	/**
	 * The default value of the '{@link #getTotalInstances() <em>Total Instances</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTotalInstances()
	 * @generated
	 * @ordered
	 */
	protected static final int TOTAL_INSTANCES_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getTotalInstances() <em>Total Instances</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTotalInstances()
	 * @generated
	 * @ordered
	 */
	protected int totalInstances = TOTAL_INSTANCES_EDEFAULT;

	/**
	 * The default value of the '{@link #getCollectedSize() <em>Collected Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCollectedSize()
	 * @generated
	 * @ordered
	 */
	protected static final int COLLECTED_SIZE_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getCollectedSize() <em>Collected Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCollectedSize()
	 * @generated
	 * @ordered
	 */
	protected int collectedSize = COLLECTED_SIZE_EDEFAULT;

	/**
	 * The default value of the '{@link #getCollectedInstances() <em>Collected Instances</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCollectedInstances()
	 * @generated
	 * @ordered
	 */
	protected static final int COLLECTED_INSTANCES_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getCollectedInstances() <em>Collected Instances</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCollectedInstances()
	 * @generated
	 * @ordered
	 */
	protected int collectedInstances = COLLECTED_INSTANCES_EDEFAULT;

	/**
	 * The default value of the '{@link #getTotalCpuTime() <em>Total Cpu Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTotalCpuTime()
	 * @generated
	 * @ordered
	 */
	protected static final double TOTAL_CPU_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getTotalCpuTime() <em>Total Cpu Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTotalCpuTime()
	 * @generated
	 * @ordered
	 */
	protected double totalCpuTime = TOTAL_CPU_TIME_EDEFAULT;

	/**
	 * The cached value of the '{@link #getObjects() <em>Objects</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getObjects()
	 * @generated
	 * @ordered
	 */
	protected EList objects = null;

	/**
	 * The cached value of the '{@link #getLoadedBy() <em>Loaded By</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLoadedBy()
	 * @generated
	 * @ordered
	 */
	protected TRCThread loadedBy = null;

	/**
	 * The cached value of the '{@link #getMethods() <em>Methods</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMethods()
	 * @generated
	 * @ordered
	 */
	protected EList methods = null;

	/**
	 * The cached value of the '{@link #getClassObjects() <em>Class Objects</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getClassObjects()
	 * @generated
	 * @ordered
	 */
	protected EList classObjects = null;

	/**
	 * The cached value of the '{@link #getClassLoader() <em>Class Loader</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getClassLoader()
	 * @generated
	 * @ordered
	 */
	protected TRCClassLoader classLoader = null;

	/**
	 * The cached value of the '{@link #getSourceInfo() <em>Source Info</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSourceInfo()
	 * @generated
	 * @ordered
	 */
	protected TRCSourceInfo sourceInfo = null;

	/**
	 * The cached value of the '{@link #getEnclosedBy() <em>Enclosed By</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEnclosedBy()
	 * @generated
	 * @ordered
	 */
	protected TRCClass enclosedBy = null;

	/**
	 * The cached value of the '{@link #getExtends() <em>Extends</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getExtends()
	 * @generated
	 * @ordered
	 */
	protected EList extends_ = null;

	/**
	 * The cached value of the '{@link #getImplements() <em>Implements</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getImplements()
	 * @generated
	 * @ordered
	 */
	protected EList implements_ = null;

	/**
	 * The cached value of the '{@link #getLocks() <em>Locks</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLocks()
	 * @generated
	 * @ordered
	 */
	protected EList locks = null;

	protected TRCClassSnapshot _currentSnapshot;
	protected TRCClassSnapshot _previousSnapshot;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TRCClassImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setBaseTime(double newBaseTime) {
		double oldBaseTime = baseTime;
		baseTime = newBaseTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_CLASS__BASE_TIME, oldBaseTime, baseTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getBaseTime() {
		return baseTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCalls(int newCalls) {
		int oldCalls = calls;
		calls = newCalls;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_CLASS__CALLS, oldCalls, calls));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getCalls() {
		return calls;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setClassLoader(TRCClassLoader newClassLoader) {
		TRCClassLoader oldClassLoader = classLoader;
		classLoader = newClassLoader;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_CLASS__CLASS_LOADER, oldClassLoader, classLoader));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCClassLoader getClassLoader() {
		if (classLoader != null && classLoader.eIsProxy()) {
			TRCClassLoader oldClassLoader = classLoader;
			classLoader = (TRCClassLoader)eResolveProxy((InternalEObject)classLoader);
			if (classLoader != oldClassLoader) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TracePackage.TRC_CLASS__CLASS_LOADER, oldClassLoader, classLoader));
			}
		}
		return classLoader;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getClassObjects() {
		if (classObjects == null) {
			classObjects = new EObjectResolvingEList(TRCObject.class, this, TracePackage.TRC_CLASS__CLASS_OBJECTS);
		}
		return classObjects;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCollectedInstances(int newCollectedInstances) {
		int oldCollectedInstances = collectedInstances;
		collectedInstances = newCollectedInstances;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_CLASS__COLLECTED_INSTANCES, oldCollectedInstances, collectedInstances));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getTotalCpuTime() {
		return totalCpuTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTotalCpuTime(double newTotalCpuTime) {
		double oldTotalCpuTime = totalCpuTime;
		totalCpuTime = newTotalCpuTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_CLASS__TOTAL_CPU_TIME, oldTotalCpuTime, totalCpuTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getCollectedInstances() {
		return collectedInstances;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCollectedSize(int newCollectedSize) {
		int oldCollectedSize = collectedSize;
		collectedSize = newCollectedSize;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_CLASS__COLLECTED_SIZE, oldCollectedSize, collectedSize));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getCollectedSize() {
		return collectedSize;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCumulativeTime(double newCumulativeTime) {
		double oldCumulativeTime = cumulativeTime;
		cumulativeTime = newCumulativeTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_CLASS__CUMULATIVE_TIME, oldCumulativeTime, cumulativeTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getCumulativeTime() {
		return cumulativeTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setEnclosedBy(TRCClass newEnclosedBy) {
		TRCClass oldEnclosedBy = enclosedBy;
		enclosedBy = newEnclosedBy;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_CLASS__ENCLOSED_BY, oldEnclosedBy, enclosedBy));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCClass getEnclosedBy() {
		if (enclosedBy != null && enclosedBy.eIsProxy()) {
			TRCClass oldEnclosedBy = enclosedBy;
			enclosedBy = (TRCClass)eResolveProxy((InternalEObject)enclosedBy);
			if (enclosedBy != oldEnclosedBy) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TracePackage.TRC_CLASS__ENCLOSED_BY, oldEnclosedBy, enclosedBy));
			}
		}
		return enclosedBy;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getExtends() {
		if (extends_ == null) {
			extends_ = new EObjectResolvingEList(TRCClass.class, this, TracePackage.TRC_CLASS__EXTENDS);
		}
		return extends_;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public long getId() {
		return id;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setId(long newId) {
		long oldId = id;
		id = newId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_CLASS__ID, oldId, id));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getImplements() {
		if (implements_ == null) {
			implements_ = new EObjectResolvingEList(TRCClass.class, this, TracePackage.TRC_CLASS__IMPLEMENTS);
		}
		return implements_;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getLocks() {
		if (locks == null) {
			locks = new EObjectResolvingEList(TRCLockAccess.class, this, TracePackage.TRC_CLASS__LOCKS);
		}
		return locks;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInheritedBaseTime(double newInheritedBaseTime) {
		double oldInheritedBaseTime = inheritedBaseTime;
		inheritedBaseTime = newInheritedBaseTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_CLASS__INHERITED_BASE_TIME, oldInheritedBaseTime, inheritedBaseTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getInheritedBaseTime() {
		return inheritedBaseTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInheritedCalls(int newInheritedCalls) {
		int oldInheritedCalls = inheritedCalls;
		inheritedCalls = newInheritedCalls;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_CLASS__INHERITED_CALLS, oldInheritedCalls, inheritedCalls));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getInheritedCalls() {
		return inheritedCalls;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInheritedCumulativeTime(double newInheritedCumulativeTime) {
		double oldInheritedCumulativeTime = inheritedCumulativeTime;
		inheritedCumulativeTime = newInheritedCumulativeTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_CLASS__INHERITED_CUMULATIVE_TIME, oldInheritedCumulativeTime, inheritedCumulativeTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getInheritedCumulativeTime() {
		return inheritedCumulativeTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInterface(boolean newInterface) {
		boolean oldInterface = interface_;
		interface_ = newInterface;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_CLASS__INTERFACE, oldInterface, interface_));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isInterface() {
		return interface_;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLineNo(int newLineNo) {
		int oldLineNo = lineNo;
		lineNo = newLineNo;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_CLASS__LINE_NO, oldLineNo, lineNo));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getLineNo() {
		return lineNo;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLoadTime(double newLoadTime) {
		double oldLoadTime = loadTime;
		loadTime = newLoadTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_CLASS__LOAD_TIME, oldLoadTime, loadTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getLoadTime() {
		return loadTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLoadedBy(TRCThread newLoadedBy) {
		TRCThread oldLoadedBy = loadedBy;
		loadedBy = newLoadedBy;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_CLASS__LOADED_BY, oldLoadedBy, loadedBy));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCThread getLoadedBy() {
		if (loadedBy != null && loadedBy.eIsProxy()) {
			TRCThread oldLoadedBy = loadedBy;
			loadedBy = (TRCThread)eResolveProxy((InternalEObject)loadedBy);
			if (loadedBy != oldLoadedBy) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TracePackage.TRC_CLASS__LOADED_BY, oldLoadedBy, loadedBy));
			}
		}
		return loadedBy;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getMethods() {
		if (methods == null) {
			methods = new EObjectContainmentWithInverseEList(TRCMethod.class, this, TracePackage.TRC_CLASS__METHODS, TracePackage.TRC_METHOD__DEFINING_CLASS);
		}
		return methods;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_CLASS__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getObjects() {
		if (objects == null) {
			objects = new EObjectWithInverseResolvingEList(TRCObject.class, this, TracePackage.TRC_CLASS__OBJECTS, TracePackage.TRC_OBJECT__IS_A);
		}
		return objects;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPackage(TRCPackage newPackage) {
		if (newPackage != eContainer || (eContainerFeatureID != TracePackage.TRC_CLASS__PACKAGE && newPackage != null)) {
			if (EcoreUtil.isAncestor(this, newPackage))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eContainer != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newPackage != null)
				msgs = ((InternalEObject)newPackage).eInverseAdd(this, TracePackage.TRC_PACKAGE__CLASSES, TRCPackage.class, msgs);
			msgs = eBasicSetContainer((InternalEObject)newPackage, TracePackage.TRC_CLASS__PACKAGE, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_CLASS__PACKAGE, newPackage, newPackage));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCPackage getPackage() {
		if (eContainerFeatureID != TracePackage.TRC_CLASS__PACKAGE) return null;
		return (TRCPackage)eContainer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSize(int newSize) {
		int oldSize = size;
		size = newSize;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_CLASS__SIZE, oldSize, size));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getSize() {
		return size;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSourceInfo(TRCSourceInfo newSourceInfo) {
		TRCSourceInfo oldSourceInfo = sourceInfo;
		sourceInfo = newSourceInfo;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_CLASS__SOURCE_INFO, oldSourceInfo, sourceInfo));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCSourceInfo getSourceInfo() {
		if (sourceInfo != null && sourceInfo.eIsProxy()) {
			TRCSourceInfo oldSourceInfo = sourceInfo;
			sourceInfo = (TRCSourceInfo)eResolveProxy((InternalEObject)sourceInfo);
			if (sourceInfo != oldSourceInfo) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TracePackage.TRC_CLASS__SOURCE_INFO, oldSourceInfo, sourceInfo));
			}
		}
		return sourceInfo;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTotalInstances(int newTotalInstances) {
		int oldTotalInstances = totalInstances;
		totalInstances = newTotalInstances;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_CLASS__TOTAL_INSTANCES, oldTotalInstances, totalInstances));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getTotalInstances() {
		return totalInstances;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTotalSize(int newTotalSize) {
		int oldTotalSize = totalSize;
		totalSize = newTotalSize;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_CLASS__TOTAL_SIZE, oldTotalSize, totalSize));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getTotalSize() {
		return totalSize;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setUnloadTime(double newUnloadTime) {
		double oldUnloadTime = unloadTime;
		unloadTime = newUnloadTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_CLASS__UNLOAD_TIME, oldUnloadTime, unloadTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getUnloadTime() {
		return unloadTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCClassLoader basicGetClassLoader() {
		return classLoader;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCClass basicGetEnclosedBy() {
		return enclosedBy;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCThread basicGetLoadedBy() {
		return loadedBy;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCSourceInfo basicGetSourceInfo() {
		return sourceInfo;
	}

	/**
	 *
	 */
	public int computeDelta(IDelta delta) {
		TRCClassSnapshot delta1 = (TRCClassSnapshot) delta;

		if ((_currentSnapshot == null) || (_previousSnapshot == null)) {
			delta1.baseTime = 0;
			delta1.calls = 0;
			delta1.collectedInstances = 0;
			delta1.collectedSize = 0;
			delta1.cumulativeTime = 0;
			delta1.inheritedBaseTime = 0;
			delta1.inheritedCalls = 0;
			delta1.inheritedCumulativeTime = 0;
			delta1.totalInstances = 0;
			delta1.totalSize = 0;
			delta1.totalCpuTime = 0;

			return -1;
		}

		delta1.baseTime = _currentSnapshot.baseTime - _previousSnapshot.baseTime;
		delta1.calls = _currentSnapshot.calls - _previousSnapshot.calls;
		delta1.collectedInstances =
			_currentSnapshot.collectedInstances
				- _previousSnapshot.collectedInstances;
		delta1.collectedSize =
			_currentSnapshot.collectedSize - _previousSnapshot.collectedSize;
		delta1.cumulativeTime =
			_currentSnapshot.cumulativeTime - _previousSnapshot.cumulativeTime;
		delta1.inheritedBaseTime =
			_currentSnapshot.inheritedBaseTime
				- _previousSnapshot.inheritedBaseTime;
		delta1.inheritedCalls =
			_currentSnapshot.inheritedCalls - _previousSnapshot.inheritedCalls;
		delta1.inheritedCumulativeTime =
			_currentSnapshot.inheritedCumulativeTime
				- _previousSnapshot.inheritedCumulativeTime;
		delta1.totalInstances =
			_currentSnapshot.totalInstances - _previousSnapshot.totalInstances;
		delta1.totalSize =
			_currentSnapshot.totalSize - _previousSnapshot.totalSize;
		delta1.totalCpuTime = 
			_currentSnapshot.totalCpuTime - _previousSnapshot.totalCpuTime;

		return 1;
	}

	public int computeDelta(IDelta delta, int featureID) {
		TRCClassSnapshot delta1 = (TRCClassSnapshot) delta;

		if ((_currentSnapshot == null) || (_previousSnapshot == null)) {
			switch (featureID) {
				case TracePackage.TRC_CLASS__BASE_TIME :
					delta1.baseTime = 0;

					break;

				case TracePackage.TRC_CLASS__CUMULATIVE_TIME :
					delta1.cumulativeTime = 0;

					break;

				case TracePackage.TRC_CLASS__CALLS :
					delta1.calls = 0;

					break;

				case TracePackage.TRC_CLASS__INHERITED_CALLS :
					delta1.inheritedCalls = 0;

					break;

				case TracePackage.TRC_CLASS__INHERITED_BASE_TIME :
					delta1.inheritedBaseTime = 0;

					break;

				case TracePackage.TRC_CLASS__INHERITED_CUMULATIVE_TIME :
					delta1.inheritedCumulativeTime = 0;

					break;

				case TracePackage.TRC_CLASS__TOTAL_SIZE :
					delta1.totalSize = 0;

					break;

				case TracePackage.TRC_CLASS__TOTAL_INSTANCES :
					delta1.totalInstances = 0;

					break;

				case TracePackage.TRC_CLASS__COLLECTED_SIZE :
					delta1.collectedSize = 0;

					break;

				case TracePackage.TRC_CLASS__COLLECTED_INSTANCES :
					delta1.collectedInstances = 0;

				case TracePackage.TRC_CLASS__TOTAL_CPU_TIME :
					delta1.totalCpuTime = 0;
				
					break;
			}

			return -1;
		}

		switch (featureID) {
			case TracePackage.TRC_CLASS__BASE_TIME :
				delta1.baseTime =
					_currentSnapshot.baseTime - _previousSnapshot.baseTime;

				break;

			case TracePackage.TRC_CLASS__CUMULATIVE_TIME :
				delta1.cumulativeTime =
					_currentSnapshot.cumulativeTime
						- _previousSnapshot.cumulativeTime;

				break;

			case TracePackage.TRC_CLASS__CALLS :
				delta1.calls = _currentSnapshot.calls - _previousSnapshot.calls;

				break;

			case TracePackage.TRC_CLASS__INHERITED_CALLS :
				delta1.inheritedCalls =
					_currentSnapshot.inheritedCalls
						- _previousSnapshot.inheritedCalls;

				break;

			case TracePackage.TRC_CLASS__INHERITED_BASE_TIME :
				delta1.inheritedBaseTime =
					_currentSnapshot.inheritedBaseTime
						- _previousSnapshot.inheritedBaseTime;

				break;

			case TracePackage.TRC_CLASS__INHERITED_CUMULATIVE_TIME :
				delta1.inheritedCumulativeTime =
					_currentSnapshot.inheritedCumulativeTime
						- _previousSnapshot.inheritedCumulativeTime;

				break;

			case TracePackage.TRC_CLASS__TOTAL_SIZE :
				delta1.totalSize =
					_currentSnapshot.totalSize - _previousSnapshot.totalSize;

				break;

			case TracePackage.TRC_CLASS__TOTAL_INSTANCES :
				delta1.totalInstances =
					_currentSnapshot.totalInstances
						- _previousSnapshot.totalInstances;

				break;

			case TracePackage.TRC_CLASS__COLLECTED_SIZE :
				delta1.collectedSize =
					_currentSnapshot.collectedSize
						- _previousSnapshot.collectedSize;

				break;

			case TracePackage.TRC_CLASS__COLLECTED_INSTANCES :
				delta1.collectedInstances =
					_currentSnapshot.collectedInstances
						- _previousSnapshot.collectedInstances;

			case TracePackage.TRC_CLASS__TOTAL_CPU_TIME :
				delta1.totalCpuTime =
					_currentSnapshot.totalCpuTime
						- _previousSnapshot.totalCpuTime;
			
				break;
		}

		return 1;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case TracePackage.TRC_CLASS__PACKAGE:
					return ((InternalEObject)eContainer).eInverseRemove(this, TracePackage.TRC_PACKAGE__CLASSES, TRCPackage.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_CLASS__ID:
				return new Long(getId());
			case TracePackage.TRC_CLASS__NAME:
				return getName();
			case TracePackage.TRC_CLASS__SIZE:
				return new Integer(getSize());
			case TracePackage.TRC_CLASS__LOAD_TIME:
				return new Double(getLoadTime());
			case TracePackage.TRC_CLASS__UNLOAD_TIME:
				return new Double(getUnloadTime());
			case TracePackage.TRC_CLASS__INTERFACE:
				return isInterface() ? Boolean.TRUE : Boolean.FALSE;
			case TracePackage.TRC_CLASS__LINE_NO:
				return new Integer(getLineNo());
			case TracePackage.TRC_CLASS__BASE_TIME:
				return new Double(getBaseTime());
			case TracePackage.TRC_CLASS__CUMULATIVE_TIME:
				return new Double(getCumulativeTime());
			case TracePackage.TRC_CLASS__CALLS:
				return new Integer(getCalls());
			case TracePackage.TRC_CLASS__INHERITED_CALLS:
				return new Integer(getInheritedCalls());
			case TracePackage.TRC_CLASS__INHERITED_BASE_TIME:
				return new Double(getInheritedBaseTime());
			case TracePackage.TRC_CLASS__INHERITED_CUMULATIVE_TIME:
				return new Double(getInheritedCumulativeTime());
			case TracePackage.TRC_CLASS__TOTAL_SIZE:
				return new Integer(getTotalSize());
			case TracePackage.TRC_CLASS__TOTAL_INSTANCES:
				return new Integer(getTotalInstances());
			case TracePackage.TRC_CLASS__COLLECTED_SIZE:
				return new Integer(getCollectedSize());
			case TracePackage.TRC_CLASS__COLLECTED_INSTANCES:
				return new Integer(getCollectedInstances());
			case TracePackage.TRC_CLASS__TOTAL_CPU_TIME:
				return new Double(getTotalCpuTime());
			case TracePackage.TRC_CLASS__OBJECTS:
				return getObjects();
			case TracePackage.TRC_CLASS__LOADED_BY:
				if (resolve) return getLoadedBy();
				return basicGetLoadedBy();
			case TracePackage.TRC_CLASS__METHODS:
				return getMethods();
			case TracePackage.TRC_CLASS__CLASS_OBJECTS:
				return getClassObjects();
			case TracePackage.TRC_CLASS__PACKAGE:
				return getPackage();
			case TracePackage.TRC_CLASS__CLASS_LOADER:
				if (resolve) return getClassLoader();
				return basicGetClassLoader();
			case TracePackage.TRC_CLASS__SOURCE_INFO:
				if (resolve) return getSourceInfo();
				return basicGetSourceInfo();
			case TracePackage.TRC_CLASS__ENCLOSED_BY:
				if (resolve) return getEnclosedBy();
				return basicGetEnclosedBy();
			case TracePackage.TRC_CLASS__EXTENDS:
				return getExtends();
			case TracePackage.TRC_CLASS__IMPLEMENTS:
				return getImplements();
			case TracePackage.TRC_CLASS__LOCKS:
				return getLocks();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case TracePackage.TRC_CLASS__OBJECTS:
					return ((InternalEList)getObjects()).basicAdd(otherEnd, msgs);
				case TracePackage.TRC_CLASS__METHODS:
					return ((InternalEList)getMethods()).basicAdd(otherEnd, msgs);
				case TracePackage.TRC_CLASS__PACKAGE:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, TracePackage.TRC_CLASS__PACKAGE, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case TracePackage.TRC_CLASS__OBJECTS:
					return ((InternalEList)getObjects()).basicRemove(otherEnd, msgs);
				case TracePackage.TRC_CLASS__METHODS:
					return ((InternalEList)getMethods()).basicRemove(otherEnd, msgs);
				case TracePackage.TRC_CLASS__PACKAGE:
					return eBasicSetContainer(null, TracePackage.TRC_CLASS__PACKAGE, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_CLASS__ID:
				return id != ID_EDEFAULT;
			case TracePackage.TRC_CLASS__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case TracePackage.TRC_CLASS__SIZE:
				return size != SIZE_EDEFAULT;
			case TracePackage.TRC_CLASS__LOAD_TIME:
				return loadTime != LOAD_TIME_EDEFAULT;
			case TracePackage.TRC_CLASS__UNLOAD_TIME:
				return unloadTime != UNLOAD_TIME_EDEFAULT;
			case TracePackage.TRC_CLASS__INTERFACE:
				return interface_ != INTERFACE_EDEFAULT;
			case TracePackage.TRC_CLASS__LINE_NO:
				return lineNo != LINE_NO_EDEFAULT;
			case TracePackage.TRC_CLASS__BASE_TIME:
				return baseTime != BASE_TIME_EDEFAULT;
			case TracePackage.TRC_CLASS__CUMULATIVE_TIME:
				return cumulativeTime != CUMULATIVE_TIME_EDEFAULT;
			case TracePackage.TRC_CLASS__CALLS:
				return calls != CALLS_EDEFAULT;
			case TracePackage.TRC_CLASS__INHERITED_CALLS:
				return inheritedCalls != INHERITED_CALLS_EDEFAULT;
			case TracePackage.TRC_CLASS__INHERITED_BASE_TIME:
				return inheritedBaseTime != INHERITED_BASE_TIME_EDEFAULT;
			case TracePackage.TRC_CLASS__INHERITED_CUMULATIVE_TIME:
				return inheritedCumulativeTime != INHERITED_CUMULATIVE_TIME_EDEFAULT;
			case TracePackage.TRC_CLASS__TOTAL_SIZE:
				return totalSize != TOTAL_SIZE_EDEFAULT;
			case TracePackage.TRC_CLASS__TOTAL_INSTANCES:
				return totalInstances != TOTAL_INSTANCES_EDEFAULT;
			case TracePackage.TRC_CLASS__COLLECTED_SIZE:
				return collectedSize != COLLECTED_SIZE_EDEFAULT;
			case TracePackage.TRC_CLASS__COLLECTED_INSTANCES:
				return collectedInstances != COLLECTED_INSTANCES_EDEFAULT;
			case TracePackage.TRC_CLASS__TOTAL_CPU_TIME:
				return totalCpuTime != TOTAL_CPU_TIME_EDEFAULT;
			case TracePackage.TRC_CLASS__OBJECTS:
				return objects != null && !objects.isEmpty();
			case TracePackage.TRC_CLASS__LOADED_BY:
				return loadedBy != null;
			case TracePackage.TRC_CLASS__METHODS:
				return methods != null && !methods.isEmpty();
			case TracePackage.TRC_CLASS__CLASS_OBJECTS:
				return classObjects != null && !classObjects.isEmpty();
			case TracePackage.TRC_CLASS__PACKAGE:
				return getPackage() != null;
			case TracePackage.TRC_CLASS__CLASS_LOADER:
				return classLoader != null;
			case TracePackage.TRC_CLASS__SOURCE_INFO:
				return sourceInfo != null;
			case TracePackage.TRC_CLASS__ENCLOSED_BY:
				return enclosedBy != null;
			case TracePackage.TRC_CLASS__EXTENDS:
				return extends_ != null && !extends_.isEmpty();
			case TracePackage.TRC_CLASS__IMPLEMENTS:
				return implements_ != null && !implements_.isEmpty();
			case TracePackage.TRC_CLASS__LOCKS:
				return locks != null && !locks.isEmpty();
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_CLASS__ID:
				setId(((Long)newValue).longValue());
				return;
			case TracePackage.TRC_CLASS__NAME:
				setName((String)newValue);
				return;
			case TracePackage.TRC_CLASS__SIZE:
				setSize(((Integer)newValue).intValue());
				return;
			case TracePackage.TRC_CLASS__LOAD_TIME:
				setLoadTime(((Double)newValue).doubleValue());
				return;
			case TracePackage.TRC_CLASS__UNLOAD_TIME:
				setUnloadTime(((Double)newValue).doubleValue());
				return;
			case TracePackage.TRC_CLASS__INTERFACE:
				setInterface(((Boolean)newValue).booleanValue());
				return;
			case TracePackage.TRC_CLASS__LINE_NO:
				setLineNo(((Integer)newValue).intValue());
				return;
			case TracePackage.TRC_CLASS__BASE_TIME:
				setBaseTime(((Double)newValue).doubleValue());
				return;
			case TracePackage.TRC_CLASS__CUMULATIVE_TIME:
				setCumulativeTime(((Double)newValue).doubleValue());
				return;
			case TracePackage.TRC_CLASS__CALLS:
				setCalls(((Integer)newValue).intValue());
				return;
			case TracePackage.TRC_CLASS__INHERITED_CALLS:
				setInheritedCalls(((Integer)newValue).intValue());
				return;
			case TracePackage.TRC_CLASS__INHERITED_BASE_TIME:
				setInheritedBaseTime(((Double)newValue).doubleValue());
				return;
			case TracePackage.TRC_CLASS__INHERITED_CUMULATIVE_TIME:
				setInheritedCumulativeTime(((Double)newValue).doubleValue());
				return;
			case TracePackage.TRC_CLASS__TOTAL_SIZE:
				setTotalSize(((Integer)newValue).intValue());
				return;
			case TracePackage.TRC_CLASS__TOTAL_INSTANCES:
				setTotalInstances(((Integer)newValue).intValue());
				return;
			case TracePackage.TRC_CLASS__COLLECTED_SIZE:
				setCollectedSize(((Integer)newValue).intValue());
				return;
			case TracePackage.TRC_CLASS__COLLECTED_INSTANCES:
				setCollectedInstances(((Integer)newValue).intValue());
				return;
			case TracePackage.TRC_CLASS__TOTAL_CPU_TIME:
				setTotalCpuTime(((Double)newValue).doubleValue());
				return;
			case TracePackage.TRC_CLASS__OBJECTS:
				getObjects().clear();
				getObjects().addAll((Collection)newValue);
				return;
			case TracePackage.TRC_CLASS__LOADED_BY:
				setLoadedBy((TRCThread)newValue);
				return;
			case TracePackage.TRC_CLASS__METHODS:
				getMethods().clear();
				getMethods().addAll((Collection)newValue);
				return;
			case TracePackage.TRC_CLASS__CLASS_OBJECTS:
				getClassObjects().clear();
				getClassObjects().addAll((Collection)newValue);
				return;
			case TracePackage.TRC_CLASS__PACKAGE:
				setPackage((TRCPackage)newValue);
				return;
			case TracePackage.TRC_CLASS__CLASS_LOADER:
				setClassLoader((TRCClassLoader)newValue);
				return;
			case TracePackage.TRC_CLASS__SOURCE_INFO:
				setSourceInfo((TRCSourceInfo)newValue);
				return;
			case TracePackage.TRC_CLASS__ENCLOSED_BY:
				setEnclosedBy((TRCClass)newValue);
				return;
			case TracePackage.TRC_CLASS__EXTENDS:
				getExtends().clear();
				getExtends().addAll((Collection)newValue);
				return;
			case TracePackage.TRC_CLASS__IMPLEMENTS:
				getImplements().clear();
				getImplements().addAll((Collection)newValue);
				return;
			case TracePackage.TRC_CLASS__LOCKS:
				getLocks().clear();
				getLocks().addAll((Collection)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_CLASS__ID:
				setId(ID_EDEFAULT);
				return;
			case TracePackage.TRC_CLASS__NAME:
				setName(NAME_EDEFAULT);
				return;
			case TracePackage.TRC_CLASS__SIZE:
				setSize(SIZE_EDEFAULT);
				return;
			case TracePackage.TRC_CLASS__LOAD_TIME:
				setLoadTime(LOAD_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_CLASS__UNLOAD_TIME:
				setUnloadTime(UNLOAD_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_CLASS__INTERFACE:
				setInterface(INTERFACE_EDEFAULT);
				return;
			case TracePackage.TRC_CLASS__LINE_NO:
				setLineNo(LINE_NO_EDEFAULT);
				return;
			case TracePackage.TRC_CLASS__BASE_TIME:
				setBaseTime(BASE_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_CLASS__CUMULATIVE_TIME:
				setCumulativeTime(CUMULATIVE_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_CLASS__CALLS:
				setCalls(CALLS_EDEFAULT);
				return;
			case TracePackage.TRC_CLASS__INHERITED_CALLS:
				setInheritedCalls(INHERITED_CALLS_EDEFAULT);
				return;
			case TracePackage.TRC_CLASS__INHERITED_BASE_TIME:
				setInheritedBaseTime(INHERITED_BASE_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_CLASS__INHERITED_CUMULATIVE_TIME:
				setInheritedCumulativeTime(INHERITED_CUMULATIVE_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_CLASS__TOTAL_SIZE:
				setTotalSize(TOTAL_SIZE_EDEFAULT);
				return;
			case TracePackage.TRC_CLASS__TOTAL_INSTANCES:
				setTotalInstances(TOTAL_INSTANCES_EDEFAULT);
				return;
			case TracePackage.TRC_CLASS__COLLECTED_SIZE:
				setCollectedSize(COLLECTED_SIZE_EDEFAULT);
				return;
			case TracePackage.TRC_CLASS__COLLECTED_INSTANCES:
				setCollectedInstances(COLLECTED_INSTANCES_EDEFAULT);
				return;
			case TracePackage.TRC_CLASS__TOTAL_CPU_TIME:
				setTotalCpuTime(TOTAL_CPU_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_CLASS__OBJECTS:
				getObjects().clear();
				return;
			case TracePackage.TRC_CLASS__LOADED_BY:
				setLoadedBy((TRCThread)null);
				return;
			case TracePackage.TRC_CLASS__METHODS:
				getMethods().clear();
				return;
			case TracePackage.TRC_CLASS__CLASS_OBJECTS:
				getClassObjects().clear();
				return;
			case TracePackage.TRC_CLASS__PACKAGE:
				setPackage((TRCPackage)null);
				return;
			case TracePackage.TRC_CLASS__CLASS_LOADER:
				setClassLoader((TRCClassLoader)null);
				return;
			case TracePackage.TRC_CLASS__SOURCE_INFO:
				setSourceInfo((TRCSourceInfo)null);
				return;
			case TracePackage.TRC_CLASS__ENCLOSED_BY:
				setEnclosedBy((TRCClass)null);
				return;
			case TracePackage.TRC_CLASS__EXTENDS:
				getExtends().clear();
				return;
			case TracePackage.TRC_CLASS__IMPLEMENTS:
				getImplements().clear();
				return;
			case TracePackage.TRC_CLASS__LOCKS:
				getLocks().clear();
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 *
	 */
	public void removeSnapshot() {
		_currentSnapshot = null;
		_previousSnapshot = null;
	}

	/**
	 *
	 */
	public ISnapshot retrieveSnapshot() {
		if(_currentSnapshot==null)
		{
			takeSnapshot();
		}
		return _currentSnapshot;
	}

	/**
	 *
	 */
	public void takeSnapshot() {
		TRCClassSnapshot temp = _previousSnapshot;

		_previousSnapshot = _currentSnapshot;
		_currentSnapshot = temp;

		if (_currentSnapshot == null) {
			_currentSnapshot = new TRCClassSnapshot();
		}

		_currentSnapshot.baseTime = baseTime;
		_currentSnapshot.calls = calls;
		_currentSnapshot.collectedInstances = collectedInstances;
		_currentSnapshot.collectedSize = collectedSize;
		_currentSnapshot.cumulativeTime = cumulativeTime;
		_currentSnapshot.inheritedBaseTime = inheritedBaseTime;
		_currentSnapshot.inheritedCalls = inheritedCalls;
		_currentSnapshot.inheritedCumulativeTime = inheritedCumulativeTime;
		_currentSnapshot.totalInstances = totalInstances;
		_currentSnapshot.totalSize = totalSize;
		_currentSnapshot.totalCpuTime = totalCpuTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (id: ");
		result.append(id);
		result.append(", name: ");
		result.append(name);
		result.append(", size: ");
		result.append(size);
		result.append(", loadTime: ");
		result.append(loadTime);
		result.append(", unloadTime: ");
		result.append(unloadTime);
		result.append(", interface: ");
		result.append(interface_);
		result.append(", lineNo: ");
		result.append(lineNo);
		result.append(", baseTime: ");
		result.append(baseTime);
		result.append(", cumulativeTime: ");
		result.append(cumulativeTime);
		result.append(", calls: ");
		result.append(calls);
		result.append(", inheritedCalls: ");
		result.append(inheritedCalls);
		result.append(", inheritedBaseTime: ");
		result.append(inheritedBaseTime);
		result.append(", inheritedCumulativeTime: ");
		result.append(inheritedCumulativeTime);
		result.append(", totalSize: ");
		result.append(totalSize);
		result.append(", totalInstances: ");
		result.append(totalInstances);
		result.append(", collectedSize: ");
		result.append(collectedSize);
		result.append(", collectedInstances: ");
		result.append(collectedInstances);
		result.append(", totalCpuTime: ");
		result.append(totalCpuTime);
		result.append(')');
		return result.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return TracePackage.eINSTANCE.getTRCClass();
	}

	//~ Inner Classes ------------------------------------------------------------------------------

	/**
	 * @author slavescu
	 */
	public static class TRCClassSnapshot implements IDelta, ISnapshot {
		protected double baseTime = BASE_TIME_EDEFAULT;
		protected double cumulativeTime = CUMULATIVE_TIME_EDEFAULT;
		protected double inheritedBaseTime = INHERITED_BASE_TIME_EDEFAULT;
		protected double inheritedCumulativeTime =
			INHERITED_CUMULATIVE_TIME_EDEFAULT;
		protected int calls = CALLS_EDEFAULT;
		protected int collectedInstances = COLLECTED_INSTANCES_EDEFAULT;
		protected int collectedSize = COLLECTED_SIZE_EDEFAULT;
		protected int inheritedCalls = INHERITED_CALLS_EDEFAULT;
		protected int totalInstances = TOTAL_INSTANCES_EDEFAULT;
		protected int totalSize = TOTAL_SIZE_EDEFAULT;
		protected double totalCpuTime = TOTAL_CPU_TIME_EDEFAULT;

		public double getBaseTime() {
			return baseTime;
		}

		public int getCalls() {
			return calls;
		}

		public int getCollectedInstances() {
			return collectedInstances;
		}

		public int getCollectedSize() {
			return collectedSize;
		}

		public double getCumulativeTime() {
			return cumulativeTime;
		}

		public double getInheritedBaseTime() {
			return inheritedBaseTime;
		}

		public int getInheritedCalls() {
			return inheritedCalls;
		}

		public double getInheritedCumulativeTime() {
			return inheritedCumulativeTime;
		}

		public int getTotalInstances() {
			return totalInstances;
		}

		public int getTotalSize() {
			return totalSize;
		}

		public Object get(int featureID) {
			switch (featureID) {
				case TracePackage.TRC_CLASS__BASE_TIME :
					return new Double(getBaseTime());

				case TracePackage.TRC_CLASS__CUMULATIVE_TIME :
					return new Double(getCumulativeTime());

				case TracePackage.TRC_CLASS__CALLS :
					return new Integer(getCalls());

				case TracePackage.TRC_CLASS__INHERITED_CALLS :
					return new Integer(getInheritedCalls());

				case TracePackage.TRC_CLASS__INHERITED_BASE_TIME :
					return new Double(getInheritedBaseTime());

				case TracePackage.TRC_CLASS__INHERITED_CUMULATIVE_TIME :
					return new Double(getInheritedCumulativeTime());

				case TracePackage.TRC_CLASS__TOTAL_SIZE :
					return new Integer(getTotalSize());

				case TracePackage.TRC_CLASS__TOTAL_INSTANCES :
					return new Integer(getTotalInstances());

				case TracePackage.TRC_CLASS__COLLECTED_SIZE :
					return new Integer(getCollectedSize());

				case TracePackage.TRC_CLASS__COLLECTED_INSTANCES :
					return new Integer(getCollectedInstances());

				case TracePackage.TRC_CLASS__TOTAL_CPU_TIME :
					return new Double(getTotalCpuTime());
			}

			return null;
		}
		/**
		 * @return Returns the totalCpuTime.
		 */
		public double getTotalCpuTime() {
			return totalCpuTime;
		}
		/**
		 * @param totalCpuTime The totalCpuTime to set.
		 */
		public void setTotalCpuTime(double totalCpuTime) {
			this.totalCpuTime = totalCpuTime;
		}
	}
}
//TRCClassImpl
