/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TRCObjectAllocationSiteImpl.java,v 1.7 2005/02/10 22:13:41 qiyanli Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.trace.impl;

import java.util.Map;
import java.util.Map.Entry;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCObjectAllocationSite;
import org.eclipse.hyades.models.trace.TracePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TRC Object Allocation Site</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCObjectAllocationSiteImpl#getAtLine <em>At Line</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCObjectAllocationSiteImpl#getTRCObjectAllocationSitesEntry <em>TRC Object Allocation Sites Entry</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCObjectAllocationSiteImpl#getAllocatedObject <em>Allocated Object</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TRCObjectAllocationSiteImpl extends EObjectImpl implements TRCObjectAllocationSite {
	/**
	 * The default value of the '{@link #getAtLine() <em>At Line</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAtLine()
	 * @generated
	 * @ordered
	 */
	protected static final int AT_LINE_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getAtLine() <em>At Line</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAtLine()
	 * @generated
	 * @ordered
	 */
	protected int atLine = AT_LINE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getAllocatedObject() <em>Allocated Object</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAllocatedObject()
	 * @generated
	 * @ordered
	 */
	protected TRCObject allocatedObject = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TRCObjectAllocationSiteImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return TracePackage.eINSTANCE.getTRCObjectAllocationSite();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getAtLine() {
		return atLine;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAtLine(int newAtLine) {
		int oldAtLine = atLine;
		atLine = newAtLine;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_OBJECT_ALLOCATION_SITE__AT_LINE, oldAtLine, atLine));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Entry getTRCObjectAllocationSitesEntry() {
		if (eContainerFeatureID != TracePackage.TRC_OBJECT_ALLOCATION_SITE__TRC_OBJECT_ALLOCATION_SITES_ENTRY) return null;
		return (Entry)eContainer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTRCObjectAllocationSitesEntry(Entry newTRCObjectAllocationSitesEntry) {
		if (newTRCObjectAllocationSitesEntry != eContainer || (eContainerFeatureID != TracePackage.TRC_OBJECT_ALLOCATION_SITE__TRC_OBJECT_ALLOCATION_SITES_ENTRY && newTRCObjectAllocationSitesEntry != null)) {
			if (EcoreUtil.isAncestor(this, (EObject)newTRCObjectAllocationSitesEntry))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eContainer != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newTRCObjectAllocationSitesEntry != null)
				msgs = ((InternalEObject)newTRCObjectAllocationSitesEntry).eInverseAdd(this, TracePackage.TRC_OBJECT_ALLOCATION_SITES_ENTRY__VALUE, Map.Entry.class, msgs);
			msgs = eBasicSetContainer((InternalEObject)newTRCObjectAllocationSitesEntry, TracePackage.TRC_OBJECT_ALLOCATION_SITE__TRC_OBJECT_ALLOCATION_SITES_ENTRY, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_OBJECT_ALLOCATION_SITE__TRC_OBJECT_ALLOCATION_SITES_ENTRY, newTRCObjectAllocationSitesEntry, newTRCObjectAllocationSitesEntry));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCObject getAllocatedObject() {
		if (allocatedObject != null && allocatedObject.eIsProxy()) {
			TRCObject oldAllocatedObject = allocatedObject;
			allocatedObject = (TRCObject)eResolveProxy((InternalEObject)allocatedObject);
			if (allocatedObject != oldAllocatedObject) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TracePackage.TRC_OBJECT_ALLOCATION_SITE__ALLOCATED_OBJECT, oldAllocatedObject, allocatedObject));
			}
		}
		return allocatedObject;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCObject basicGetAllocatedObject() {
		return allocatedObject;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAllocatedObject(TRCObject newAllocatedObject) {
		TRCObject oldAllocatedObject = allocatedObject;
		allocatedObject = newAllocatedObject;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_OBJECT_ALLOCATION_SITE__ALLOCATED_OBJECT, oldAllocatedObject, allocatedObject));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case TracePackage.TRC_OBJECT_ALLOCATION_SITE__TRC_OBJECT_ALLOCATION_SITES_ENTRY:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, TracePackage.TRC_OBJECT_ALLOCATION_SITE__TRC_OBJECT_ALLOCATION_SITES_ENTRY, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case TracePackage.TRC_OBJECT_ALLOCATION_SITE__TRC_OBJECT_ALLOCATION_SITES_ENTRY:
					return eBasicSetContainer(null, TracePackage.TRC_OBJECT_ALLOCATION_SITE__TRC_OBJECT_ALLOCATION_SITES_ENTRY, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case TracePackage.TRC_OBJECT_ALLOCATION_SITE__TRC_OBJECT_ALLOCATION_SITES_ENTRY:
					return ((InternalEObject)eContainer).eInverseRemove(this, TracePackage.TRC_OBJECT_ALLOCATION_SITES_ENTRY__VALUE, Map.Entry.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_OBJECT_ALLOCATION_SITE__AT_LINE:
				return new Integer(getAtLine());
			case TracePackage.TRC_OBJECT_ALLOCATION_SITE__TRC_OBJECT_ALLOCATION_SITES_ENTRY:
				return getTRCObjectAllocationSitesEntry();
			case TracePackage.TRC_OBJECT_ALLOCATION_SITE__ALLOCATED_OBJECT:
				if (resolve) return getAllocatedObject();
				return basicGetAllocatedObject();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_OBJECT_ALLOCATION_SITE__AT_LINE:
				setAtLine(((Integer)newValue).intValue());
				return;
			case TracePackage.TRC_OBJECT_ALLOCATION_SITE__TRC_OBJECT_ALLOCATION_SITES_ENTRY:
				setTRCObjectAllocationSitesEntry((Entry)newValue);
				return;
			case TracePackage.TRC_OBJECT_ALLOCATION_SITE__ALLOCATED_OBJECT:
				setAllocatedObject((TRCObject)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_OBJECT_ALLOCATION_SITE__AT_LINE:
				setAtLine(AT_LINE_EDEFAULT);
				return;
			case TracePackage.TRC_OBJECT_ALLOCATION_SITE__TRC_OBJECT_ALLOCATION_SITES_ENTRY:
				setTRCObjectAllocationSitesEntry((Entry)null);
				return;
			case TracePackage.TRC_OBJECT_ALLOCATION_SITE__ALLOCATED_OBJECT:
				setAllocatedObject((TRCObject)null);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_OBJECT_ALLOCATION_SITE__AT_LINE:
				return atLine != AT_LINE_EDEFAULT;
			case TracePackage.TRC_OBJECT_ALLOCATION_SITE__TRC_OBJECT_ALLOCATION_SITES_ENTRY:
				return getTRCObjectAllocationSitesEntry() != null;
			case TracePackage.TRC_OBJECT_ALLOCATION_SITE__ALLOCATED_OBJECT:
				return allocatedObject != null;
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (atLine: ");
		result.append(atLine);
		result.append(')');
		return result.toString();
	}

} //TRCObjectAllocationSiteImpl
