/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TRCTypedObjectValueImpl.java,v 1.7 2005/02/10 22:13:42 qiyanli Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.trace.impl;

import java.util.Map;
import java.util.Map.Entry;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.hyades.models.trace.TRCInputOutputContainer;
import org.eclipse.hyades.models.trace.TRCObjectValueKind;
import org.eclipse.hyades.models.trace.TRCObjectValuePosition;
import org.eclipse.hyades.models.trace.TRCTraceObject;
import org.eclipse.hyades.models.trace.TRCTypedObjectValue;
import org.eclipse.hyades.models.trace.TracePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TRC Typed Object Value</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCTypedObjectValueImpl#getValueKind <em>Value Kind</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCTypedObjectValueImpl#getPositionKind <em>Position Kind</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCTypedObjectValueImpl#getPosition <em>Position</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCTypedObjectValueImpl#getObject <em>Object</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TRCTypedObjectValueImpl extends TRCObjectValueImpl implements TRCTypedObjectValue {
	/**
	 * The default value of the '{@link #getValueKind() <em>Value Kind</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getValueKind()
	 * @generated
	 * @ordered
	 */
	protected static final TRCObjectValueKind VALUE_KIND_EDEFAULT = TRCObjectValueKind.THIS_LITERAL;

	/**
	 * The cached value of the '{@link #getValueKind() <em>Value Kind</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getValueKind()
	 * @generated
	 * @ordered
	 */
	protected TRCObjectValueKind valueKind = VALUE_KIND_EDEFAULT;

	/**
	 * The default value of the '{@link #getPositionKind() <em>Position Kind</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPositionKind()
	 * @generated
	 * @ordered
	 */
	protected static final TRCObjectValuePosition POSITION_KIND_EDEFAULT = TRCObjectValuePosition.BEFORE_LITERAL;

	/**
	 * The cached value of the '{@link #getPositionKind() <em>Position Kind</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPositionKind()
	 * @generated
	 * @ordered
	 */
	protected TRCObjectValuePosition positionKind = POSITION_KIND_EDEFAULT;

	/**
	 * The default value of the '{@link #getPosition() <em>Position</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPosition()
	 * @generated
	 * @ordered
	 */
	protected static final short POSITION_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getPosition() <em>Position</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPosition()
	 * @generated
	 * @ordered
	 */
	protected short position = POSITION_EDEFAULT;

	/**
	 * The cached value of the '{@link #getObject() <em>Object</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getObject()
	 * @generated
	 * @ordered
	 */
	protected TRCTraceObject object = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TRCTypedObjectValueImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return TracePackage.eINSTANCE.getTRCTypedObjectValue();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCObjectValueKind getValueKind() {
		return valueKind;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setValueKind(TRCObjectValueKind newValueKind) {
		TRCObjectValueKind oldValueKind = valueKind;
		valueKind = newValueKind == null ? VALUE_KIND_EDEFAULT : newValueKind;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_TYPED_OBJECT_VALUE__VALUE_KIND, oldValueKind, valueKind));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCObjectValuePosition getPositionKind() {
		return positionKind;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPositionKind(TRCObjectValuePosition newPositionKind) {
		TRCObjectValuePosition oldPositionKind = positionKind;
		positionKind = newPositionKind == null ? POSITION_KIND_EDEFAULT : newPositionKind;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_TYPED_OBJECT_VALUE__POSITION_KIND, oldPositionKind, positionKind));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public short getPosition() {
		return position;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPosition(short newPosition) {
		short oldPosition = position;
		position = newPosition;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_TYPED_OBJECT_VALUE__POSITION, oldPosition, position));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCTraceObject getObject() {
		if (object != null && object.eIsProxy()) {
			TRCTraceObject oldObject = object;
			object = (TRCTraceObject)eResolveProxy((InternalEObject)object);
			if (object != oldObject) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TracePackage.TRC_TYPED_OBJECT_VALUE__OBJECT, oldObject, object));
			}
		}
		return object;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCTraceObject basicGetObject() {
		return object;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setObject(TRCTraceObject newObject) {
		TRCTraceObject oldObject = object;
		object = newObject;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_TYPED_OBJECT_VALUE__OBJECT, oldObject, object));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case TracePackage.TRC_TYPED_OBJECT_VALUE__TRC_INPUT_OUTPUT_ENTRY:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, TracePackage.TRC_TYPED_OBJECT_VALUE__TRC_INPUT_OUTPUT_ENTRY, msgs);
				case TracePackage.TRC_TYPED_OBJECT_VALUE__CONTAINER:
					if (container != null)
						msgs = ((InternalEObject)container).eInverseRemove(this, TracePackage.TRC_INPUT_OUTPUT_CONTAINER__INPUT_OUTPUT_VALUES, TRCInputOutputContainer.class, msgs);
					return basicSetContainer((TRCInputOutputContainer)otherEnd, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case TracePackage.TRC_TYPED_OBJECT_VALUE__TRC_INPUT_OUTPUT_ENTRY:
					return eBasicSetContainer(null, TracePackage.TRC_TYPED_OBJECT_VALUE__TRC_INPUT_OUTPUT_ENTRY, msgs);
				case TracePackage.TRC_TYPED_OBJECT_VALUE__CONTAINER:
					return basicSetContainer(null, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case TracePackage.TRC_TYPED_OBJECT_VALUE__TRC_INPUT_OUTPUT_ENTRY:
					return ((InternalEObject)eContainer).eInverseRemove(this, TracePackage.TRC_INPUT_OUTPUT_ENTRY__VALUE, Map.Entry.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_TYPED_OBJECT_VALUE__STRING_VALUE:
				return getStringValue();
			case TracePackage.TRC_TYPED_OBJECT_VALUE__TRC_INPUT_OUTPUT_ENTRY:
				return getTRCInputOutputEntry();
			case TracePackage.TRC_TYPED_OBJECT_VALUE__CONTAINER:
				if (resolve) return getContainer();
				return basicGetContainer();
			case TracePackage.TRC_TYPED_OBJECT_VALUE__VALUE_KIND:
				return getValueKind();
			case TracePackage.TRC_TYPED_OBJECT_VALUE__POSITION_KIND:
				return getPositionKind();
			case TracePackage.TRC_TYPED_OBJECT_VALUE__POSITION:
				return new Short(getPosition());
			case TracePackage.TRC_TYPED_OBJECT_VALUE__OBJECT:
				if (resolve) return getObject();
				return basicGetObject();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_TYPED_OBJECT_VALUE__STRING_VALUE:
				setStringValue((String)newValue);
				return;
			case TracePackage.TRC_TYPED_OBJECT_VALUE__TRC_INPUT_OUTPUT_ENTRY:
				setTRCInputOutputEntry((Entry)newValue);
				return;
			case TracePackage.TRC_TYPED_OBJECT_VALUE__CONTAINER:
				setContainer((TRCInputOutputContainer)newValue);
				return;
			case TracePackage.TRC_TYPED_OBJECT_VALUE__VALUE_KIND:
				setValueKind((TRCObjectValueKind)newValue);
				return;
			case TracePackage.TRC_TYPED_OBJECT_VALUE__POSITION_KIND:
				setPositionKind((TRCObjectValuePosition)newValue);
				return;
			case TracePackage.TRC_TYPED_OBJECT_VALUE__POSITION:
				setPosition(((Short)newValue).shortValue());
				return;
			case TracePackage.TRC_TYPED_OBJECT_VALUE__OBJECT:
				setObject((TRCTraceObject)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_TYPED_OBJECT_VALUE__STRING_VALUE:
				setStringValue(STRING_VALUE_EDEFAULT);
				return;
			case TracePackage.TRC_TYPED_OBJECT_VALUE__TRC_INPUT_OUTPUT_ENTRY:
				setTRCInputOutputEntry((Entry)null);
				return;
			case TracePackage.TRC_TYPED_OBJECT_VALUE__CONTAINER:
				setContainer((TRCInputOutputContainer)null);
				return;
			case TracePackage.TRC_TYPED_OBJECT_VALUE__VALUE_KIND:
				setValueKind(VALUE_KIND_EDEFAULT);
				return;
			case TracePackage.TRC_TYPED_OBJECT_VALUE__POSITION_KIND:
				setPositionKind(POSITION_KIND_EDEFAULT);
				return;
			case TracePackage.TRC_TYPED_OBJECT_VALUE__POSITION:
				setPosition(POSITION_EDEFAULT);
				return;
			case TracePackage.TRC_TYPED_OBJECT_VALUE__OBJECT:
				setObject((TRCTraceObject)null);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_TYPED_OBJECT_VALUE__STRING_VALUE:
				return STRING_VALUE_EDEFAULT == null ? stringValue != null : !STRING_VALUE_EDEFAULT.equals(stringValue);
			case TracePackage.TRC_TYPED_OBJECT_VALUE__TRC_INPUT_OUTPUT_ENTRY:
				return getTRCInputOutputEntry() != null;
			case TracePackage.TRC_TYPED_OBJECT_VALUE__CONTAINER:
				return container != null;
			case TracePackage.TRC_TYPED_OBJECT_VALUE__VALUE_KIND:
				return valueKind != VALUE_KIND_EDEFAULT;
			case TracePackage.TRC_TYPED_OBJECT_VALUE__POSITION_KIND:
				return positionKind != POSITION_KIND_EDEFAULT;
			case TracePackage.TRC_TYPED_OBJECT_VALUE__POSITION:
				return position != POSITION_EDEFAULT;
			case TracePackage.TRC_TYPED_OBJECT_VALUE__OBJECT:
				return object != null;
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (valueKind: ");
		result.append(valueKind);
		result.append(", positionKind: ");
		result.append(positionKind);
		result.append(", position: ");
		result.append(position);
		result.append(')');
		return result.toString();
	}

} //TRCTypedObjectValueImpl
