/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TraceAdapterFactory.java,v 1.16 2005/02/10 22:13:42 qiyanli Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.trace.util;

import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.AbstractTRCCollectionBoundary;
import org.eclipse.hyades.models.hierarchy.AbstractTRCProcess;
import org.eclipse.hyades.models.trace.*;

import org.eclipse.hyades.models.trace.TRCAggregatedMethodInvocation;
import org.eclipse.hyades.models.trace.TRCAggregatedObjectReference;
import org.eclipse.hyades.models.trace.TRCArrayClass;
import org.eclipse.hyades.models.trace.TRCCallerCalleeInvocationInfo;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCClassLoader;
import org.eclipse.hyades.models.trace.TRCCollectionBoundary;
import org.eclipse.hyades.models.trace.TRCFullHeapObject;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;
import org.eclipse.hyades.models.trace.TRCHeapDump;
import org.eclipse.hyades.models.trace.TRCHeapObject;
import org.eclipse.hyades.models.trace.TRCHeapRoot;
import org.eclipse.hyades.models.trace.TRCInputOutputContainer;
import org.eclipse.hyades.models.trace.TRCLLData;
import org.eclipse.hyades.models.trace.TRCLineCoverageData;
import org.eclipse.hyades.models.trace.TRCLinePerformanceData;
import org.eclipse.hyades.models.trace.TRCLockAccess;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCMethodWithLLData;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCObjectAllocationSite;
import org.eclipse.hyades.models.trace.TRCObjectReference;
import org.eclipse.hyades.models.trace.TRCObjectValue;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TRCSourceInfo;
import org.eclipse.hyades.models.trace.TRCSourceInfoWithLLData;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCThreadDeadEvent;
import org.eclipse.hyades.models.trace.TRCThreadEvent;
import org.eclipse.hyades.models.trace.TRCThreadRunningEvent;
import org.eclipse.hyades.models.trace.TRCThreadSleepingEvent;
import org.eclipse.hyades.models.trace.TRCThreadWaitingForLockEvent;
import org.eclipse.hyades.models.trace.TRCThreadWaitingForObjectEvent;
import org.eclipse.hyades.models.trace.TRCTraceObject;
import org.eclipse.hyades.models.trace.TRCTypedObjectValue;
import org.eclipse.hyades.models.trace.TracePackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Adapter Factory</b> for the model.
 * It provides an adapter <code>createXXX</code> method for each class of the model.
 * <!-- end-user-doc -->
 * @see org.eclipse.hyades.models.trace.TracePackage
 * @generated
 */
public class TraceAdapterFactory extends AdapterFactoryImpl {
	/**
	 * The cached model package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static TracePackage modelPackage;

	/**
	 * Creates an instance of the adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TraceAdapterFactory() {
		if (modelPackage == null) {
			modelPackage = TracePackage.eINSTANCE;
		}
	}

	/**
	 * Returns whether this factory is applicable for the type of the object.
	 * <!-- begin-user-doc -->
	 * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
	 * <!-- end-user-doc -->
	 * @return whether this factory is applicable for the type of the object.
	 * @generated
	 */
	public boolean isFactoryForType(Object object) {
		if (object == modelPackage) {
			return true;
		}
		if (object instanceof EObject) {
			return ((EObject)object).eClass().getEPackage() == modelPackage;
		}
		return false;
	}

	/**
	 * The switch the delegates to the <code>createXXX</code> methods.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TraceSwitch modelSwitch =
		new TraceSwitch() {
			public Object caseTRCObject(TRCObject object) {
				return createTRCObjectAdapter();
			}
			public Object caseTRCClass(TRCClass object) {
				return createTRCClassAdapter();
			}
			public Object caseTRCMethodInvocation(TRCMethodInvocation object) {
				return createTRCMethodInvocationAdapter();
			}
			public Object caseTRCProcess(TRCProcess object) {
				return createTRCProcessAdapter();
			}
			public Object caseTRCThread(TRCThread object) {
				return createTRCThreadAdapter();
			}
			public Object caseTRCMethod(TRCMethod object) {
				return createTRCMethodAdapter();
			}
			public Object caseTRCPackage(TRCPackage object) {
				return createTRCPackageAdapter();
			}
			public Object caseTRCCollectionBoundary(TRCCollectionBoundary object) {
				return createTRCCollectionBoundaryAdapter();
			}
			public Object caseTRCClassLoader(TRCClassLoader object) {
				return createTRCClassLoaderAdapter();
			}
			public Object caseTRCSourceInfo(TRCSourceInfo object) {
				return createTRCSourceInfoAdapter();
			}
			public Object caseTRCHeapObject(TRCHeapObject object) {
				return createTRCHeapObjectAdapter();
			}
			public Object caseTRCFullTraceObject(TRCFullTraceObject object) {
				return createTRCFullTraceObjectAdapter();
			}
			public Object caseTRCTraceObject(TRCTraceObject object) {
				return createTRCTraceObjectAdapter();
			}
			public Object caseTRCFullHeapObject(TRCFullHeapObject object) {
				return createTRCFullHeapObjectAdapter();
			}
			public Object caseTRCObjectReference(TRCObjectReference object) {
				return createTRCObjectReferenceAdapter();
			}
			public Object caseTRCHeapDump(TRCHeapDump object) {
				return createTRCHeapDumpAdapter();
			}
			public Object caseTRCAggregatedMethodInvocation(TRCAggregatedMethodInvocation object) {
				return createTRCAggregatedMethodInvocationAdapter();
			}
			public Object caseTRCFullMethodInvocation(TRCFullMethodInvocation object) {
				return createTRCFullMethodInvocationAdapter();
			}
			public Object caseTRCHeapRoot(TRCHeapRoot object) {
				return createTRCHeapRootAdapter();
			}
			public Object caseTRCArrayClass(TRCArrayClass object) {
				return createTRCArrayClassAdapter();
			}
			public Object caseTRCAggregatedObjectReference(TRCAggregatedObjectReference object) {
				return createTRCAggregatedObjectReferenceAdapter();
			}
			public Object caseTRCThreadEvent(TRCThreadEvent object) {
				return createTRCThreadEventAdapter();
			}
			public Object caseTRCThreadSleepingEvent(TRCThreadSleepingEvent object) {
				return createTRCThreadSleepingEventAdapter();
			}
			public Object caseTRCThreadWaitingForObjectEvent(TRCThreadWaitingForObjectEvent object) {
				return createTRCThreadWaitingForObjectEventAdapter();
			}
			public Object caseTRCThreadWaitingForLockEvent(TRCThreadWaitingForLockEvent object) {
				return createTRCThreadWaitingForLockEventAdapter();
			}
			public Object caseTRCThreadRunningEvent(TRCThreadRunningEvent object) {
				return createTRCThreadRunningEventAdapter();
			}
			public Object caseTRCThreadDeadEvent(TRCThreadDeadEvent object) {
				return createTRCThreadDeadEventAdapter();
			}
			public Object caseTRCMethodWithLLData(TRCMethodWithLLData object) {
				return createTRCMethodWithLLDataAdapter();
			}
			public Object caseTRCLLData(TRCLLData object) {
				return createTRCLLDataAdapter();
			}
			public Object caseTRCSourceInfoWithLLData(TRCSourceInfoWithLLData object) {
				return createTRCSourceInfoWithLLDataAdapter();
			}
			public Object caseTRCLineCoverageData(TRCLineCoverageData object) {
				return createTRCLineCoverageDataAdapter();
			}
			public Object caseTRCObjectValue(TRCObjectValue object) {
				return createTRCObjectValueAdapter();
			}
			public Object caseTRCInputOutputEntry(Map.Entry object) {
				return createTRCInputOutputEntryAdapter();
			}
			public Object caseTRCInputOutputContainer(TRCInputOutputContainer object) {
				return createTRCInputOutputContainerAdapter();
			}
			public Object caseTRCCallerCalleeInvocationInfo(TRCCallerCalleeInvocationInfo object) {
				return createTRCCallerCalleeInvocationInfoAdapter();
			}
			public Object caseTRCTypedObjectValue(TRCTypedObjectValue object) {
				return createTRCTypedObjectValueAdapter();
			}
			public Object caseTRCMthdLckAccEntry(Map.Entry object) {
				return createTRCMthdLckAccEntryAdapter();
			}
			public Object caseTRCLockAccess(TRCLockAccess object) {
				return createTRCLockAccessAdapter();
			}
			public Object caseTRCLinePerformanceData(TRCLinePerformanceData object) {
				return createTRCLinePerformanceDataAdapter();
			}
			public Object caseTRCObjectAllocationSitesEntry(Map.Entry object) {
				return createTRCObjectAllocationSitesEntryAdapter();
			}
			public Object caseTRCObjectAllocationSite(TRCObjectAllocationSite object) {
				return createTRCObjectAllocationSiteAdapter();
			}
			public Object caseTRCThreadDeadLockEvent(TRCThreadDeadLockEvent object) {
				return createTRCThreadDeadLockEventAdapter();
			}
			public Object caseAbstractTRCProcess(AbstractTRCProcess object) {
				return createAbstractTRCProcessAdapter();
			}
			public Object caseAbstractTRCCollectionBoundary(AbstractTRCCollectionBoundary object) {
				return createAbstractTRCCollectionBoundaryAdapter();
			}
			public Object defaultCase(EObject object) {
				return createEObjectAdapter();
			}
		};

	/**
	 * Creates an adapter for the <code>target</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param target the object to adapt.
	 * @return the adapter for the <code>target</code>.
	 * @generated
	 */
	public Adapter createAdapter(Notifier target) {
		return (Adapter)modelSwitch.doSwitch((EObject)target);
	}


	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCObject <em>TRC Object</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCObject
	 * @generated
	 */
	public Adapter createTRCObjectAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCClass <em>TRC Class</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCClass
	 * @generated
	 */
	public Adapter createTRCClassAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCMethodInvocation <em>TRC Method Invocation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCMethodInvocation
	 * @generated
	 */
	public Adapter createTRCMethodInvocationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCProcess <em>TRC Process</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCProcess
	 * @generated
	 */
	public Adapter createTRCProcessAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCThread <em>TRC Thread</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCThread
	 * @generated
	 */
	public Adapter createTRCThreadAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCMethod <em>TRC Method</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCMethod
	 * @generated
	 */
	public Adapter createTRCMethodAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCPackage <em>TRC Package</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCPackage
	 * @generated
	 */
	public Adapter createTRCPackageAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCCollectionBoundary <em>TRC Collection Boundary</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCCollectionBoundary
	 * @generated
	 */
	public Adapter createTRCCollectionBoundaryAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCClassLoader <em>TRC Class Loader</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCClassLoader
	 * @generated
	 */
	public Adapter createTRCClassLoaderAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCSourceInfo <em>TRC Source Info</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCSourceInfo
	 * @generated
	 */
	public Adapter createTRCSourceInfoAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCHeapObject <em>TRC Heap Object</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCHeapObject
	 * @generated
	 */
	public Adapter createTRCHeapObjectAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCFullTraceObject <em>TRC Full Trace Object</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCFullTraceObject
	 * @generated
	 */
	public Adapter createTRCFullTraceObjectAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCTraceObject <em>TRC Trace Object</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCTraceObject
	 * @generated
	 */
	public Adapter createTRCTraceObjectAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCFullHeapObject <em>TRC Full Heap Object</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCFullHeapObject
	 * @generated
	 */
	public Adapter createTRCFullHeapObjectAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCObjectReference <em>TRC Object Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCObjectReference
	 * @generated
	 */
	public Adapter createTRCObjectReferenceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCHeapDump <em>TRC Heap Dump</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCHeapDump
	 * @generated
	 */
	public Adapter createTRCHeapDumpAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCAggregatedMethodInvocation <em>TRC Aggregated Method Invocation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCAggregatedMethodInvocation
	 * @generated
	 */
	public Adapter createTRCAggregatedMethodInvocationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCFullMethodInvocation <em>TRC Full Method Invocation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCFullMethodInvocation
	 * @generated
	 */
	public Adapter createTRCFullMethodInvocationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCHeapRoot <em>TRC Heap Root</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCHeapRoot
	 * @generated
	 */
	public Adapter createTRCHeapRootAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCArrayClass <em>TRC Array Class</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCArrayClass
	 * @generated
	 */
	public Adapter createTRCArrayClassAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCAggregatedObjectReference <em>TRC Aggregated Object Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCAggregatedObjectReference
	 * @generated
	 */
	public Adapter createTRCAggregatedObjectReferenceAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCThreadEvent <em>TRC Thread Event</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCThreadEvent
	 * @generated
	 */
	public Adapter createTRCThreadEventAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCThreadSleepingEvent <em>TRC Thread Sleeping Event</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCThreadSleepingEvent
	 * @generated
	 */
	public Adapter createTRCThreadSleepingEventAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCThreadWaitingForObjectEvent <em>TRC Thread Waiting For Object Event</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCThreadWaitingForObjectEvent
	 * @generated
	 */
	public Adapter createTRCThreadWaitingForObjectEventAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCThreadWaitingForLockEvent <em>TRC Thread Waiting For Lock Event</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCThreadWaitingForLockEvent
	 * @generated
	 */
	public Adapter createTRCThreadWaitingForLockEventAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCThreadRunningEvent <em>TRC Thread Running Event</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCThreadRunningEvent
	 * @generated
	 */
	public Adapter createTRCThreadRunningEventAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCThreadDeadEvent <em>TRC Thread Dead Event</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCThreadDeadEvent
	 * @generated
	 */
	public Adapter createTRCThreadDeadEventAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCMethodWithLLData <em>TRC Method With LL Data</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCMethodWithLLData
	 * @generated
	 */
	public Adapter createTRCMethodWithLLDataAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCLLData <em>TRCLL Data</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCLLData
	 * @generated
	 */
	public Adapter createTRCLLDataAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCSourceInfoWithLLData <em>TRC Source Info With LL Data</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCSourceInfoWithLLData
	 * @generated
	 */
	public Adapter createTRCSourceInfoWithLLDataAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCLineCoverageData <em>TRC Line Coverage Data</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCLineCoverageData
	 * @generated
	 */
	public Adapter createTRCLineCoverageDataAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCObjectValue <em>TRC Object Value</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCObjectValue
	 * @generated
	 */
	public Adapter createTRCObjectValueAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link java.util.Map.Entry <em>TRC Input Output Entry</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see java.util.Map.Entry
	 * @generated
	 */
	public Adapter createTRCInputOutputEntryAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCInputOutputContainer <em>TRC Input Output Container</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCInputOutputContainer
	 * @generated
	 */
	public Adapter createTRCInputOutputContainerAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCCallerCalleeInvocationInfo <em>TRC Caller Callee Invocation Info</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCCallerCalleeInvocationInfo
	 * @generated
	 */
	public Adapter createTRCCallerCalleeInvocationInfoAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCTypedObjectValue <em>TRC Typed Object Value</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCTypedObjectValue
	 * @generated
	 */
	public Adapter createTRCTypedObjectValueAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link java.util.Map.Entry <em>TRC Mthd Lck Acc Entry</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see java.util.Map.Entry
	 * @generated
	 */
	public Adapter createTRCMthdLckAccEntryAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCLockAccess <em>TRC Lock Access</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCLockAccess
	 * @generated
	 */
	public Adapter createTRCLockAccessAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCLinePerformanceData <em>TRC Line Performance Data</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCLinePerformanceData
	 * @generated
	 */
	public Adapter createTRCLinePerformanceDataAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link java.util.Map.Entry <em>TRC Object Allocation Sites Entry</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see java.util.Map.Entry
	 * @generated
	 */
	public Adapter createTRCObjectAllocationSitesEntryAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCObjectAllocationSite <em>TRC Object Allocation Site</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCObjectAllocationSite
	 * @generated
	 */
	public Adapter createTRCObjectAllocationSiteAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.trace.TRCThreadDeadLockEvent <em>TRC Thread Dead Lock Event</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.trace.TRCThreadDeadLockEvent
	 * @generated
	 */
	public Adapter createTRCThreadDeadLockEventAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.hierarchy.AbstractTRCProcess <em>Abstract TRC Process</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.hierarchy.AbstractTRCProcess
	 * @generated
	 */
	public Adapter createAbstractTRCProcessAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.hyades.models.hierarchy.AbstractTRCCollectionBoundary <em>Abstract TRC Collection Boundary</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.hyades.models.hierarchy.AbstractTRCCollectionBoundary
	 * @generated
	 */
	public Adapter createAbstractTRCCollectionBoundaryAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for the default case.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @generated
	 */
	public Adapter createEObjectAdapter() {
		return null;
	}

} //TraceAdapterFactory
