/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: Extension2.java,v 1.4 2005/02/16 22:24:05 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.sample.editor;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.ui.editor.EditorExtension;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;

/**
 * Example of an editor extension.
 * 
 * @author marcelop
 * @since 0.0.1
 */
public class Extension2 
extends EditorExtension
{
	/**
	 * @see org.eclipse.hyades.ui.editor.IEditorExtension#createPages()
	 */
	public void createPages()
	{
		TPFTestSuite testSuite = (TPFTestSuite)getHyadesEditorPart().getEditorObject();
		getHyadesEditorPart().setTitle("Editor Extension2");
		
		Composite composite = new Composite(getHyadesEditorPart().getContainer(), SWT.NONE);
		composite.setLayout(new GridLayout(2, false));
		composite.setLayoutData(GridDataUtil.createFill());
		getHyadesEditorPart().addPage(composite);
		getHyadesEditorPart().setPageText(0, "Page 1");
		
		Label label = new Label(composite, SWT.NONE);
		label.setText("Type:");
		Text text = new Text(composite, SWT.BORDER|SWT.SINGLE);
		text.setLayoutData(GridDataUtil.createHorizontalFill());
		if(testSuite.getType() != null) text.setText(testSuite.getType());
		text.setEditable(false);

		label = new Label(composite, SWT.NONE);
		label.setText("Name:");
		text = new Text(composite, SWT.BORDER|SWT.SINGLE);
		text.setLayoutData(GridDataUtil.createHorizontalFill());
		if(testSuite.getName() != null) text.setText(testSuite.getName());
		text.setEditable(false);

		label = new Label(composite, SWT.NONE);
		label.setText("Description:");
		text = new Text(composite, SWT.BORDER|SWT.MULTI);
		GridData gridData = GridDataUtil.createHorizontalFill();
		gridData.verticalSpan = 3;
		text.setLayoutData(gridData);
		if(testSuite.getDescription() != null) text.setText(testSuite.getDescription());
		text.setEditable(false);
		
		composite = new Composite(getHyadesEditorPart().getContainer(), SWT.NONE);
		composite.setLayout(new GridLayout(1, false));
		composite.setLayoutData(GridDataUtil.createFill());
		getHyadesEditorPart().addPage(composite);		
		getHyadesEditorPart().setPageText(1, "Page 2");
		
		label = new Label(composite, SWT.NONE);
		label.setText("Summary:");
		text = new Text(composite, SWT.BORDER|SWT.MULTI);
		text.setLayoutData(GridDataUtil.createFill());
		
		StringBuffer summary = new StringBuffer();
		summary.append("Number of Test Cases: ").append(testSuite.getTestCases().size());
		summary.append("\nNumber of Test Components: ").append(testSuite.getTestComponents().size());
		summary.append("\nNumber of SUTs: ").append(testSuite.getSUTs().size());
		summary.append("\nHas Arbiter: ").append(testSuite.getArbiter()==null);
		summary.append("\nBehavior is modeled: ").append((testSuite.getBehavior()!=null) && (testSuite.getBehavior().getInteraction()!=null));
		text.setText(summary.toString());
	}

	/**
	 * @see org.eclipse.hyades.ui.editor.IEditorExtension#doSave(org.eclipse.core.runtime.IProgressMonitor)
	 */
	public void doSave(IProgressMonitor monitor)
	{

	}
	
	/**
	 * @see org.eclipse.hyades.ui.editor.IEditorExtension#getSelection()
	 */
	public IStructuredSelection getSelection()
	{
		return new StructuredSelection(getHyadesEditorPart().getEditorObject());
	}	
}
