package org.eclipse.hyades.ui.sample.svg.generator;
/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IDataInputConstants.java,v 1.4 2005/02/16 22:24:05 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

/**
 * <code>IDataInputConstants</code> interface defines constants which 
 * map to the tag names defined in the documented data input schemas and 
 * other miscellaneous values used by the implementation classes.
 * 
 * @version 1.6.1.6  
 */
public interface IDataInputConstants {
    // WidgetConfiguration schema
    String CONFIGURATION=                       "configuration";    
    String TITLE=                               "title";    
    String SUPPRESS_LEGEND=                     "suppressLegend";
    String LEGEND_TITLE=                        "legendTitle";
    String TIMESTAMP_PREFIX=                    "timestampPrefix";
    String WIDTH=                               "width";
    String HEIGHT=                              "height";
//  String FONT=                                "font";
    
    // DataUpdate schema
    String DATAUPDATE=                          "dataUpdate";    
    String DATARANGE=                           "dataRange";
    String DATASET=                             "dataSet";
    String TIMESTAMP=                           "timestamp";
    String SUMMARY=                             "summary";
    String DATARANGE1REF=                       "dataRange1Ref";
    String DATARANGE2REF=                       "dataRange2Ref";
    String SEGMENT_MARKER=                      "segmentMarker";
    String LOCATION=                            "location";
    String TYPE=                                "type";
    String TICK=                                "tick";
    String LINE=                                "line";
    String CONTINUUM=                           "continuum";
    String CATEGORIZATION=                      "categorization";
//  String MINVALUE=                            "minValue";
//  String MAXVALUE=                            "maxValue";
    String POSITION=                            "position";
    String VALUE=                               "value";
    String ACTUAL=                              "actual";
    String HOLE=                                "hole";
    String DESCRIPTION=                         "description";
    String ID=                                  "id";
    String DATAPOINT=                           "dataPoint";
    String VALUE1=                              "value1";
    String VALUE2=                              "value2";
    String TOTAL=                               "total";
    String IMAGE=                               "image";
    String URI=                                 "uri";
    String LABEL=                               "label";
    String FLYOVERLABEL=                        "flyoverLabel";
    String CODE=                                "code";
    
    // miscellaneous
    String EMPTY_STRING=                        "";
    String VALUE_TITLE=                         "valueTitle";    
    String TOTAL_TITLE=                         "totalTitle";
    String RATE_DEFINITION=                     "rateDefinition";
    String ACTUAL_RATE=                         "actualRate";    
    String X_TITLE=                             "xtitle";
    String Y_TITLE=                             "ytitle";
}

