package org.eclipse.hyades.ui.sample.svg.generator;
/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IDataInputProcessingExceptionCodes.java,v 1.4 2005/02/16 22:24:05 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

/**
 * <code>IDataInputProcessingExceptionCodes</code> interface defines the error codes 
 * used when raising exceptions of type <code>DataInputProcessingException</code>.
 * 
 * @version 1.13.1.10  
 */
public interface IDataInputProcessingExceptionCodes {	
	
	/**
	 * CATEGORY_ID_MISMATCH = 100
	 */
//	short CATEGORY_ID_MISMATCH=								100;
	
	/**
	 * DUPLICATE_POSITION_NUMBER = 101
	 */
	short DUPLICATE_POSITION_NUMBER=							101;
		
	/**
	 * INVALID_NUMBER_FORMAT = 102
	 */
	short INVALID_NUMBER_FORMAT=								102;
	
	/**
	 * INVALID_NUMBER_FORMAT = 103
	 */
	short MAXIMUM_NUMBER_OF_SEGMENT_MARKERS_EXCEEDED=			103;
	
	/**
	 * MISSING_SEGMENT_MARKERS_OR_DATAPOINT_VALUES = 104
	 */
	short MISSING_SEGMENT_MARKERS_OR_DATAPOINT_VALUES= 		104;
	
	/**
	 * MISSING_CATEGORY_NAMES = 105
	 */
//	short MISSING_CATEGORY_NAMES=								105;
	
	/**
	 * MISSING_IDS_OR_POSITIONS = 106
	 */
//	short MISSING_IDS_OR_POSITIONS=							106;
	
	/**
	 * MISSING_LABELS_OR_POSITIONS = 107
	 */
	short MISSING_LABELS_OR_POSITIONS=							107;

	/**
	 * MISSING_PERCENTAGE_OF_DATAPOINT_TOTAL_OR_POSITION = 108
	 */
	short MISSING_PERCENTAGE_OF_DATAPOINT_TOTAL_OR_POSITION=	108;
	
	/**
	 * MISSING_PERCENTAGES = 109
	 */
//	short MISSING_PERCENTAGES=									109;
	
	/**
	 * MISSING_TOTALS = 110
	 */
//	short MISSING_TOTALS=										110;
	
	/**
	 * MISSING_TOTALS_OR_POSITIONS = 111
	 */
	short MISSING_TOTALS_OR_POSITIONS=							111;
	
	/**
	 * MISSING_VALUES_OR_POSITIONS = 112
	 */
//	short MISSING_VALUES_OR_POSITIONS=							112;

	/**
	 * NO_CONTEXT_FOUND = 113
	 */
//	short NO_CONTEXT_FOUND=									113;
	
	/**
	 * NO_DATA_DOCUMENT = 114
	 */
	short NO_DATA_DOCUMENT=									114;

	/**
	 * NO_DATASET_FOUND = 115
	 */
//	short NO_DATASETS_FOUND=									115;
	
	/**
	 * NO_DESCRIPTION_FOUND = 116
	 */
//	short NO_DESCRIPTION_FOUND=								116;
	
	/**
	 * NO_IDS_FOUND = 117
	 */
//	short NO_IDS_FOUND=										117;
	
	/**
	 * NO_NAMES_FOUND = 118
	 */
	short NO_NAMES_FOUND=										118;
	
	/**
	 * NO_PERCENTAGE_OF_DATAPOINT_TOTAL_FOUND = 119
	 */
//	short NO_PERCENTAGE_OF_DATAPOINT_TOTAL_FOUND=				119;
	
	/**
	 * NO_SUMMARY_FOUND = 120
	 */
//	short NO_SUMMARY_FOUND=									120;
	
	/**
	 * NO_TIMESTAMP_FOUND = 121
	 */
//	short NO_TIMESTAMP_FOUND=									121;
	
	/**
	 * NO_TOTALS_FOUND = 122
	 */
	short NO_TOTALS_FOUND=										122;
	
	/**
	 * NO_VALUE_FOUND = 123
	 */
	short NO_VALUE_FOUND=										123;
	
	/**
	 * NO_VALUES_FOUND = 124
	 */
	short NO_VALUES_FOUND=										124;
	
	/**
	 * POSITION_NUMBER_OUT_OF_BOUNDS = 125
	 */
	short POSITION_NUMBER_OUT_OF_BOUNDS=						125;

	/**
	 * NO_RANGE_FOUND = 126
	 */
	short NO_RANGE_FOUND=	                          			126;
	
	/**
	 * NEGATIVE_IMAGE_WIDTH = 127
	 */
	short NEGATIVE_IMAGE_WIDTH=	                   			127;
	
	/**
	 * NEGATIVE_IMAGE_HEIGHT = 128
	 */
	short NEGATIVE_IMAGE_HEIGHT=	                          	128;
	
	/**
	 * UNSUPPORTED_DATA_RANGE_TYPE = 129
	 */
	short UNSUPPORTED_DATA_RANGE_TYPE=	                       	129;
	
	/**
	 * DATAPOINT_NOT_IN_CATEGORY = 130
	 */
	short DATAPOINT_NOT_IN_CATEGORY=	                       	130;
	
	
}
