package org.eclipse.hyades.ui.sample.svg.generator;
/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IGraphicDocumentDefaults.java,v 1.4 2005/02/16 22:24:05 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

/**
 * <code>IGraphicDocumentDefaults</code> interface defines constants for chart 
 * properties which have default values.
 * 
 * @version 1.2
 */
public interface IGraphicDocumentDefaults {
	/**
	 * Default font size, BASIC_FONTSIZE.
	 * 
	 * @see IGraphicDocumentStyle
	 */	
	int DEFAULT_FONTSIZE = IGraphicDocumentStyle.BASIC_FONTSIZE;
	
	/**
	 * Default font family and generic family, BASIC_FONT.
	 * 
	 * @see IGraphicDocumentStyle
	 */	
	String DEFAULT_FONT = IGraphicDocumentStyle.BASIC_FONT;
	
	/**
	 * Default colour palette, SEASIDE.
	 * 
	 * @see IGraphicDocumentStyle
	 */
	String DEFAULT_PALETTE = IUserPreferencesConstants.SEASIDE;
	
	/**
	 * Default graphic pixel width, BASIC_WITH.
	 * 
	 * @see IGraphicDocumentStyle
	 */
	String DEFAULT_WIDTH = IGraphicDocumentStyle.BASIC_WIDTH;
	
	/**
	 * Default graphic pixel height, BASIC_HEIGHT.
	 * 
	 * @see IGraphicDocumentStyle
	 */	
	String DEFAULT_HEIGHT = IGraphicDocumentStyle.BASIC_HEIGHT;

}
