package org.eclipse.hyades.ui.sample.svg.generator;
/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IGraphicDocumentStyle.java,v 1.4 2005/02/16 22:24:05 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
 
/* Please keep this comment current with the value of the corresponding style CONSTANT:
 // COMMON_STYLE 
 .st1{fill-rule:nonzero;clip-rule:nonzero;stroke:#000000;stroke-miterlimit:4;} 
 .outline{stroke-width:0.75pt; stroke:#666666; fill:#ffffff;}
 .keyline{stroke-width:0.75pt; stroke:#666666;}    
 .graphTitle {font-weight:bold; font-style:normal; font-size:11pt; fill:#000000; stroke-width:0.75pt}
 .labelsValues {font-weight:normal; font-style:normal; font-size:10pt; fill:#000000;}
 .dataValues {font-weight:normal; font-style:normal; font-size:8pt; fill:#000000;}
 .timeStamp {font-weight:normal font-style:normal; font-size:8pt; fill:#000000; text-anchor:end;opacity:0.5}
 .legendTitle {font-weight:normal font-style:normal; font-size:10pt; fill:#000000; text-anchor:start; opacity:0.6}
 .legendData {font-weight:normal font-style:normal; font-size:9pt; fill:#000000; text-anchor: start; } 
 .anchorAtEnd {text-anchor: end;}
 .anchorAtStart {text-anchor: start;}
 .anchorAtMiddle {text-anchor: middle;} 
 
 
 // METER_STYLE  
 .minmaxRate {font-weight:normal font-style:normal; font-size:8pt; fill:#000000;}
 .rateDef {font-weight:normal font-style:normal; font-size:8pt; fill:#000000;opacity:0.5}
 .critDiv {font-weight:normal font-style:normal; font-size:8pt; fill:#000000;opacity:0.5}
 .graphOutline{fill:none;}
 .ticks{fill:none;} 
 .speedometerBg{fill:#FFFFFF;}
 .innerRim{fill:#999999;}
 .outerRim{fill:#006666;}
 .needle{fill:#000000;stroke-width:1.5;stroke-linecap:round;}
 .outerCircle{fill:#000000;stroke:none;}
 .innerCircle{fill:#FFFFFF;stroke:none;}
 .center{fill-rule:nonzero;clip-rule:nonzero;stroke:#000000;stroke-miterlimit:4;}
 .safeRange{fill:#CCCCCC;stroke:none;}
 .semiCritical{fill:#FFFF99;stroke:none;}
 .critical{fill:#FF0000;stroke:none;}
 .actualRate{fill:#CCCCCC;stroke:#999999;} 
 
 // PIE_STYLE
 .pievalues {stroke:none; font-weight:normal font-style:normal; font-size:8pt; fill:#000000; text-anchor: middle;}
 .wedgeTick{fill:none;}
 .wedgeOutline{fill:none;}
 .wedgeColor{fill:#CCCCCC;stroke:none;}
 
 // XYCHART_STYLE
 .grid{stroke-width:0.75pt; stroke:#000000;}
 .gridline{stroke-width:0.75pt; stroke:#cccccc;} 
 .griddashline{stroke-width:0.75pt; stroke:#cccccc; stroke-dasharray:2; fill:none;}
 .axisLines{fill:none;}
 .axisTicks{fill:none;}
 .solidLine{fill:none;stroke:#CCCCCC;stroke-width:1;}
 .dashLine{fill:none;stroke:#CCCCCC;stroke-width:1;stroke-dasharray:2;}
 .catOutline{fill:none;}
 .catColor{fill:#003399;stroke:none;}
 .exactValuesBox{fill:#FFFFCC;stroke:#999999;stroke-width:1;}
 .xyTitleLabels {font-weight:normal; font-style:normal; font-size:10pt; fill:#000000; opacity:0.6}
*/

/**
 * <code>IGraphicDocumentStyle</code> interface defines the default CSS style classes, colour
 * palettes, and other basic attributes of the graphic.
 * 
 * @version 1.41.1.6
 */
public interface IGraphicDocumentStyle {	
	/**
	 * CSS default common style classes (rules).  
	 */
	String COMMON_STYLE = " .st1{fill-rule:nonzero;clip-rule:nonzero;stroke:#000000;stroke-miterlimit:4;} .outline{stroke-width:0.75pt; stroke:#666666; fill:#ffffff;} .keyline{stroke-width:0.75pt; stroke:#666666;} .graphTitle {font-weight:bold; font-style:normal; font-size:11pt; fill:#000000; stroke-width:0.75pt;} .labelsValues {font-weight:normal; font-style:normal; font-size:10pt; fill:#000000;} .dataValues {font-weight:normal; font-style:normal; font-size:8pt; fill:#000000;} .timeStamp {font-weight:normal; font-style:normal; font-size:8pt; fill:#000000; text-anchor:end; opacity:0.5} .legendTitle {font-weight:normal; font-style:normal; font-size:10pt; fill:#000000; text-anchor:start; opacity:0.6} .legendData {font-weight:normal; font-style:normal; font-size:9pt; text-anchor:start; fill:#000000;} .anchorAtEnd {text-anchor: end;} .anchorAtStart {text-anchor: start;} .anchorAtMiddle {text-anchor: middle;}";
	
	/**
	 * CSS default meter style classes (rules).  
	 */
	String METER_STYLE= ".minmaxRate {font-weight:normal; font-style:normal; font-size:8pt; fill:#000000;} .rateDef {font-weight:normal; font-style:normal; font-size:8pt; fill:#000000;opacity:0.5} .critDiv {font-weight:normal; font-style:normal; font-size:8pt; fill:#000000; opacity:0.5} .graphOutline{fill:none;} .ticks{fill:none;}  .speedometerBg{fill:#FFFFFF;} .innerRim{fill:#999999;} .outerRim{fill:#006666;} .needle{fill:#000000;stroke-width:1.5;stroke-linecap:round;} .outerCircle{fill:#000000;stroke:none;} .innerCircle{fill:#FFFFFF;stroke:none;} .center{fill-rule:nonzero;clip-rule:nonzero;stroke:#000000;stroke-miterlimit:4;} .safeRange{fill:#CCCCCC;stroke:none;} .semiCritical{fill:#FFFF99;stroke:none;} .critical{fill:#FF0000;stroke:none;} .actualRate{fill:#CCCCCC;stroke:#999999;} ";	
	
	/**
	 * CSS default pie style classes (rules).  
	 */
	String PIE_STYLE= " .pievalues{stroke:none; font-weight:normal; font-style:normal; font-size:8pt; fill:#000000; text-anchor: middle;}.wedgeTick{fill:none;} .wedgeOutline{fill:none;} .wedgeColor{fill:#CCCCCC;stroke:none;}";
	
	/**
	 * CSS default XYchart style classes (rules).  
	 */
	String XYCHART_STYLE= " .grid{stroke-width:0.75pt; stroke:#000000;} .gridline{stroke-width:0.75pt; stroke:#cccccc;} .griddashline{stroke-width:0.75pt; stroke:#cccccc; stroke-dasharray:2; fill:none;} .axisLines{fill:none;} .axisTicks{fill:none;} .solidLine{fill:none;stroke:#CCCCCC;stroke-width:1;} .dashLine{fill:none;stroke:#CCCCCC;stroke-width:1;stroke-dasharray:2;} .catOutline{fill:none;} .catColor{fill:#003399;stroke:none;} .exactValuesBox{fill:#FFFFCC;stroke:#999999;stroke-width:1;} .xyTitleLabels {font-weight:normal; font-style:normal; font-size:10pt; fill:#000000; opacity:0.6}";
	
	
	
	/**
	 * BASIC_WIDTH = "365"
	 */
	String BASIC_WIDTH=					"365";
	
	/**
	 * BASIC_HEIGHT = "300"
	 */
	String BASIC_HEIGHT=				"320";
	
	/**
	 * BASIC_FONT = "Arial, sans-serif"
	 */	
	String BASIC_FONT= 					"Arial, sans-serif";
	
	/**
	 * BASIC_FONTSIZE = 8
	 */	
	int BASIC_FONTSIZE= 				8;
	
	/**
	 * BASIC_FONTSTYLE = "font-weight:normal; font-style:normal; font-family:Arial; fill:#000000;"
	 */	
	String BASIC_FONTSTYLE= 			"font-weight:normal; font-style:normal; font-family:Arial; fill:#000000;";
	
	/**
	 * BASIC_SHOW_SHAPES = "On"
	 */	
	String BASIC_SHOW_SHAPES= 			"1";
	
	/**
	 * BASIC_SHOW_VALUES = "0ff"
	 */	
	String BASIC_SHOW_VALUES= 			"0";
	
	/**
	 * BASIC_SHOW_PERCENTS = "0n"
	 */	
	String BASIC_SHOW_PERCENTS= 		"1";
	
	
	
	/**
	 *  SEASIDE = #003399, #0066CC, #3399FF, #66CCFF, #CCCCFF, #9999FF, #6666FF, #3333FF, #6699FF, #99CCFF, #CCFFFF, #66CCCC, #009999, #006666, #003366 
	 */
	String [] SEASIDE_PALETTE=	{"#003399","#0066CC","#3399FF","#66CCFF","#CCCCFF","#9999FF","#6666FF","#3333FF","#6699FF","#99CCFF","#CCFFFF","#66CCCC","#009999","#006666", "#003366"};
	
	/**
	 * SUMMER = #660066, #CC0099, #FF00CC, #FF66FF, #FF99FF, #FFCCFF, #FFFFCC, #FFCC99, #FF9999, #FF6666, #CC3333, #CC0000, #990033, #660033, #990099
	 */
	String [] SUMMER_PALETTE=	{"#660066","#CC0099","#FF00CC","#FF66FF","#FF99FF","#FFCCFF","#FFFFCC","#FFCC99","#FF9999","#FF6666","#CC3333","#CC0000","#990033","#660033","#990099"};
	
	/**
	 * EARTH = #993333, #CC6633, #FF6600, #996633, #FF9900, #FFCC66, #CC9900, #999933, #CCCC00, #FFFF00, #669966, #99CC99, #336633, #669999, #99CCCC
	 */ 
	String [] EARTH_PALETTE=	{"#993333","#CC6633","#FF6600","#996633","#FF9900","#FFCC66","#CC9900","#999933","#CCCC00","#FFFF00","#669966","#99CC99","#336633","#669999","#99CCCC"};
	
	/**
	 * SPRING = #99CCCC, #339999, #336666, #66CCCC, #CC6699, #333399, #9999FF, #9966CC, #9933CC, #CC99CC, #996699, #990099, #CC33CC, #CC3399, #CC6699
	 */
	String [] SPRING_PALETTE=	{"#99CCCC","#339999","#336666","#66CCCC","#CC6699","#333399","#9999FF","#9966CC","#9933CC","#CC99CC","#996699","#990099","#CC33CC","#CC3399","#CC6699"};
	
	/**
	 * HARVEST = #FFCC99, #FFFFCC, #FFCC33, #CC9933, #FFFF33, #CCCC00, #999900, #666600, #003300, #990033, #CC3333, #CC6666, #FF9999, #FFCCCC, #CC9999
	 */ 
	String [] HARVEST_PALETTE=	{"#FFCC99","#FFFFCC","#FFCC33","#CC9933","#FFFF33","#CCCC00","#999900","#666600","#003300","#990033","#CC3333","#CC6666","#FF9999","#FFCCCC","#CC9999"};
	
	/**
	 * PASTEL =	#CC9999, #CCCCCC, #FF9999, #FFCC99, #FFCC66, #CCCC99, #FFFF99, #FFFF33, #CCFF99, #99CC99, #66CCCC, #99CCCC, #9999CC, #996699, #CC99CC  
	 */
	String [] PASTEL_PALETTE=	{"#CC9999","#CCCCCC","#FF9999","#FFCC99","#FFCC66","#CCCC99","#FFFF99","#FFFF33","#CCFF99","#99CC99","#66CCCC","#99CCCC","#9999CC","#996699","#CC99CC"};
		
					
	/**
	 * NUMBER_OF_PREFERENCES = 6
	 */
	int NUMBER_OF_PREFERENCES=		6; 
	
	
	/**
	 * STACKBAR_DEFAULT_WIDTH = 450
	 */
	String STACKBAR_DEFAULT_WIDTH=		"450"; 

	/**
	 * STACKBAR_DEFAULT_WIDTH = 450
	 */
	String GROUPBAR_DEFAULT_WIDTH=		"450"; 
	
	/**
	 * PIE_DEFAULT_WIDTH = 450
	 */
	String PIE_DEFAULT_WIDTH=			"450";
	
	/**
	 * LINE_DEFAULT_WIDTH = 450
	 */
	String LINE_DEFAULT_WIDTH=			"450";
	
	/**
	 * AREA_DEFAULT_WIDTH = 450
	 */
	String AREA_DEFAULT_WIDTH=			"450";
	
	/**
	 * SCATTER_DEFAULT_WIDTH = 450
	 */
	String SCATTER_DEFAULT_WIDTH=			"450";
			
	/**
	 * METER_DEFAULT_WIDTH = 325
	 */
	String METER_DEFAULT_WIDTH=			"325";	
	
		
}
