package org.eclipse.hyades.ui.sample.svg.generator;
/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: MeterDataRetriever.java,v 1.4 2005/02/16 22:24:05 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

import java.util.Hashtable;

import org.w3c.dom.Document;
/**
 * Data retrieval methods which retrieve data of interest to <code>SVGMeter</code> from 
 * documents which conform to the documented data input schemas. 
 * 
 * @version 1.18.1.4
 */
public class MeterDataRetriever extends CommonDataRetriever {
	/**
	 * Sole constructor.
	 */			
	MeterDataRetriever() {
		super();
	}		
		
	/**
	 * Returns from the data document the text labels which indicate the 
	 * contextual definition of the rate and its actual value, both of
	 * which are displayed by the meter graphic.
	 * 
	 * @throws DataInputProcessingException for codes <code>NO_DATA_DOCUMENT, NO_CONTEXT_FOUND, 
	 * NO_SUMMARY_FOUND</code> 
	 * @see IDataInputProcessingExceptionCodes
	 */	
	public Hashtable getLabels(Document dataDocument) throws DataInputProcessingException {
		if (dataDocument == null) {
			throwException(NO_DATA_DOCUMENT, EMPTY_STRING);
		}	
				
		Hashtable labels = new Hashtable(2);		
		
		String label = getAttributeFromSingleElement(dataDocument, DATARANGE, LABEL);
		labels.put(RATE_DEFINITION, (label != null) ? label : "");
		String summary = getAttributeFromSingleElement(dataDocument, DATAUPDATE, SUMMARY);
		labels.put(ACTUAL_RATE, (summary != null) ? summary : "");

		return labels;
	}	
		
	/**
	 * Returns from the data document the value to which the meter needle points.
	 * 
	 * @throws DataInputProcessingException for codes <code>NO_DATA_DOCUMENT, NO_VALUE_FOUND, INVALID_NUMBER_FORMAT</code> 	 
	 * @see IDataInputProcessingExceptionCodes
	 */	
	public String getNeedleValue(Document dataDocument) throws DataInputProcessingException {	
		if (dataDocument == null) {
			throwException(NO_DATA_DOCUMENT, EMPTY_STRING);
		}	
			
		// get the first datapoint value from the first dataset,ignoring position
		String result = getAttributeValueFromFirstChildOfFirstElement(dataDocument, DATASET, DATAPOINT, VALUE);	
		if (result == null || result.equals(EMPTY_STRING)) {
			throwException(NO_VALUE_FOUND, DATAPOINT);	
		}	
		// ensure it's a number
		double j = 0;
		try {
			j = Double.parseDouble(result);
		} catch (Exception exc) {
			// NumberFormatException
			throwException(INVALID_NUMBER_FORMAT, DATAPOINT);	
		}
		// restriction to non-negative integers
			if (j < 0) {
				throwException(INVALID_NUMBER_FORMAT, DATAPOINT);
			}			
		return result;				
	}		
}

