package org.eclipse.hyades.ui.sample.svg.generator;
/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SegmentMarker.java,v 1.4 2005/02/16 22:24:05 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

//import org.w3c.dom.Document;
//import org.w3c.dom.Element;
//import org.w3c.dom.NodeList;

/**
 * Representation of a Segment Marker
 * 
 * @version 1.6
 */
public class SegmentMarker {
    /**
     *  Segment marker type constant: a short line
     */
    public static final int TICK = 0;

    /**
     *  Segment marker type constant: a line across the chart
     */
    public static final int LINE = 1;
    

    private String valueString = null;
    private double value = 0.0;
    private double position = 0.0;
    private int type = TICK;
    private String label = null;
    

    /**
     *  Constructor
     *  @param valueString the value of the marker in string format
     */        
    public SegmentMarker(String valueString) {
        setValueString(valueString);
    }
    
    /**
     *  Getter for Value
     */
    public double getValue() { return value; }
    /**
     *  Getter for Value as a string
     */
    public String getValueString() { return valueString; }
    /**
     *  Setter for Value as a string
     */
    public void setValueString(String valueString) { 
        this.valueString = valueString; 
        value = Double.parseDouble(valueString);
    }
    
    
    /**
     *  Getter for Position - a value between 0 and 1 where the segment marker is drawn on the axis
     */
    public double getPosition() { return position; }
    /**
     *  Setter for Position - a value between 0 and 1 where the segment marker is drawn on the axis
     */
    public void setPosition(double position) { 
        this.position = position; 
    }
    

    /**
     *  Getter for Type
     */
    public int getType() { return type; }
    /**
     *  Setter for Type
     */
    public void setType(int type) { this.type = type; }
    
     /**
     *  Getter for Label
     */
    public String getLabel() { return label; }
     /**
     *  Setter for Label
     */
    public void setLabel(String label) { this.label = label; }

    /**
     *  Get the label if it is set, otherwise format the value according to the locale specified in the given GraphicAttributes
     *  @param attrs the GraphicAttributes that contains the current locale
     *  @return the label for display in the UI
     */
    public String getDisplayLabel(GraphicAttributes attrs) {
    	String s = getLabel();
    	if (s == null) {
    		s = attrs.formatNumber(getValue());
    	}
    	return s;
	}
}
