/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: HyadesUI.java,v 1.7 2005/03/19 00:47:44 curtispd Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui;

import org.eclipse.hyades.ui.extension.IAssociationMappingRegistry;
import org.eclipse.hyades.ui.internal.extension.AssociationMappingRegistry;

/**
 * Contains utility methods to work with the Hyades UI classes and the wide
 * context constants.
 * 
 * @author marcelop
 * @since 0.0.1
 */
public class HyadesUI
{
	/**
	 * Creates an instance of a association mapping registry.
	 * @return IAssociationMappingRegistry
	 */
	public static IAssociationMappingRegistry createAssociationMappingRegistry()
	{
		return new AssociationMappingRegistry();
	}

	/**
	 * Preference store key, that holds the value for switching to 
	 * prefered/default perspective.
	 * 
	 * Can have one of three values:
	 * <code>MessageDialogWithToggle.PROMPT</code>
	 * <code>MessageDialogWithToggle.ALWAYS</code>
	 * <code>MessageDialogWithToggle.NEVER</code> 
	 * @since 3.1
	 */
	public static final String SWITCH_TO_PERSPECTIVE_KEY = "switch_to_perspective";
}
