/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IAssociationDescriptorFilter.java,v 1.4 2005/02/16 22:24:04 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.extension;

/**
 * Instances of this interface can be used with a 
 * {@link org.eclipse.hyades.ui.extension.IAssociationMappingRegistry} so clients can
 * customize which association descriptors can be added to the registry's mappings.
 * 
 * @author marcelop
 * @since 0.0.1
 */
public interface IAssociationDescriptorFilter
{
	/**
	 * Returns <code>true</code> if the descriptor is valid or <code>false</code> 
	 * otherwise.  If this methods returns <code>false</code> the 
	 * <code>associationDescriptor</code> is removed from the its mapping.
	 * 
	 * <p>Implementors are not supposed to cache any of the argument since 
	 * they should be always retrieved through the association classes.
	 *  
	 * @param associationDescriptor
	 * @param associationMapping
	 * @return boolean
	 */
	public boolean isValid(IAssociationMapping associationMapping, IAssociationDescriptor associationDescriptor);
}
