/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: NavigatorSorterActionGroup.java,v 1.4 2005/02/16 22:24:05 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.internal.navigator.action;

import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.views.navigator.ResourceNavigatorMessages;

import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.ui.internal.navigator.NavigatorViewerSorter;

/**
 * Action group with all the pre defined criterias available in the
 * {@link org.eclipse.hyades.ui.internal.navigator.NavigatorViewerSorter}.
 * 
 * @author marcelop
 * @since 0.0.1
 */
public class NavigatorSorterActionGroup 
extends NavigatorActionGroup
{
	private NavigatorSorterAction byNameAction;
	private NavigatorSorterAction byTypeAction;
	
	/**
	 * Constructor for NavigatorSorterActionGroup
	 * @param navigator
	 */
	public NavigatorSorterActionGroup(INavigator navigator)
	{
		super(navigator);
	}

	/**
	 * @see org.eclipse.ui.actions.ActionGroup#dispose()
	 */
	public void dispose()
	{
		byNameAction = null;
		byTypeAction = null;
		
		super.dispose();
	}
	
	/**
	 * Creates the actions contained in this action group.
	 */
	protected void createActions()
	{
		byNameAction = new NavigatorSorterAction(getNavigator(), HyadesUIPlugin.getString("ACT_SORTER_NME"), NavigatorViewerSorter.NAME);
		byNameAction.setToolTipText(byNameAction.getToolTipText());
		
		byTypeAction = new NavigatorSorterAction(getNavigator(), HyadesUIPlugin.getString("ACT_SORTER_TYPE"), NavigatorViewerSorter.TYPE);
		byTypeAction.setToolTipText(byNameAction.getToolTipText());
	}

	/**
	 * @see org.eclipse.ui.actions.ActionGroup#fillActionBars(org.eclipse.ui.IActionBars)
	 */
	public void fillActionBars(IActionBars actionBars)
	{
		IMenuManager menu = actionBars.getMenuManager();
		IMenuManager submenu = new MenuManager(ResourceNavigatorMessages.getString("ResourceNavigator.sort")); //$NON-NLS-1$
		menu.add(submenu);
		submenu.add(byNameAction);
		submenu.add(byTypeAction);
	}

	/**
	 * @see org.eclipse.ui.actions.ActionGroup#updateActionBars()
	 */
	public void updateActionBars()
	{
		if(getNavigator().getViewer() != null)
		{
			ViewerSorter viewerSorter = getNavigator().getViewer().getSorter();
			if(viewerSorter instanceof NavigatorViewerSorter)
			{
				int criteria = ((NavigatorViewerSorter)viewerSorter).getCriteria();
				byNameAction.setChecked(criteria == NavigatorViewerSorter.NAME);
				byTypeAction.setChecked(criteria == NavigatorViewerSorter.TYPE);
			}
		}
	}
}
