/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: NewObjectAction.java,v 1.5 2005/02/16 22:24:05 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.internal.navigator.action;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.dialogs.NewWizard;

import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.util.ContextIds;
import org.eclipse.hyades.ui.util.IDisposable;

/**
 * This action display's a wizard that allows a user to select one creation wizard
 * to be executed.  Clients can specify the category of these creation wizards
 * using the {@link #setWizardCategory(String)} method. 
 * 
 * @author marcelop
 * @since 0.0.1
 */
public class NewObjectAction 
extends Action implements IDisposable
{
	/**
	 * The wizard dialog width
	 */
	private static final int SIZING_WIZARD_WIDTH = 500;

	/**
	 * The wizard dialog height
	 */
	private static final int SIZING_WIZARD_HEIGHT = 500;

	/**
	 * The workbench window this action will run in
	 */
	private IWorkbenchWindow window;

	/**
	 * The dialog settings from which the last usage is retrieved
	 */
	private IDialogSettings settings;
	
	/**
	 * The category of the creation wizards that are presented
	 */
	private String wizardCategory;

	/**
	 * The wizard title
	 */
	private String wizardTitle;

	/**
	 * Constructor for NewHyadesObjectAction
	 * @param wizardCategory
	 */
	public NewObjectAction()
	{
		this(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
		WorkbenchHelp.setHelp(this, HyadesUIPlugin.getID() + ContextIds.ACT_NEW_OBJ);								
	}

	/**
	 * Constructor for NewObjectAction.  Creates a new action for 
	 * launching the new project selection wizard.
	 *
	 * @param window the workbench window to query the current
	 * @param wizardCategory
	 * selection and shell for opening the wizard.
	 */
	public NewObjectAction(IWorkbenchWindow window)
	{
		super();
		this.window = window;
		ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
		setImageDescriptor(images.getImageDescriptor(ISharedImages.IMG_TOOL_NEW_WIZARD));
		setHoverImageDescriptor(images.getImageDescriptor(ISharedImages.IMG_TOOL_NEW_WIZARD));
		setDisabledImageDescriptor(images.getImageDescriptor(ISharedImages.IMG_TOOL_NEW_WIZARD_DISABLED));
		setToolTipText(getText());
		
		setSettings(HyadesUIPlugin.getInstance().getDialogSettings());
		wizardTitle = HyadesUIPlugin.getString("W_NEW");
	}
	
	/**
	 * @see org.eclipse.hyades.ui.util.IDisposable#dispose()
	 */
	public void dispose()
	{
		settings = null;
		window = null;
	}

	/**
	 * Sets the dialog settings from where the last usage settings are retrieved.  The
	 * settings defined are considered as the settings section reserved for the 
	 * wizard created by this action. 
	 * @param dialogSettings
	 */
	public void setSettings(IDialogSettings settings)
	{
		this.settings = settings;
	}
	
	/**
	 * Returns the dialog settings.
	 * @return IDialogSettings
	 */
	public IDialogSettings getSettings()
	{
		return settings;
	}
	
	/**
	 * Sets the category of the wizards that are presented by this action 
	 * @param wizardCategory
	 */
	public void setWizardCategory(String wizardCategory)
	{
		this.wizardCategory = wizardCategory;
	}

	/**
	 * Returns the category of the wizards that are presented by this action 
	 * @return String
	 */
	public String getWizardCategory()
	{
		return wizardCategory;
	}

	/**
	 * Sets the title of the wizard presented by this action 
	 * @param wizardTitle
	 */
	public void setWizardTitle(String wizardTitle)
	{
		this.wizardTitle = wizardTitle;
	}

	/**
	 * Returns the title of the wizard presented by this action 
	 * @return String
	 */
	public String getWizardTitle()
	{
		return wizardTitle;
	}

	/**
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	public void run()
	{
		// Create wizard selection wizard.
		IWorkbench workbench = PlatformUI.getWorkbench();
		NewWizard wizard = new NewWizard();
		
		String category = getWizardCategory();
		if(category != null)
			wizard.setCategoryId(category);

		ISelection selection = window.getSelectionService().getSelection();
		IStructuredSelection selectionToPass = StructuredSelection.EMPTY;
		if (selection instanceof IStructuredSelection)
			selectionToPass = (IStructuredSelection) selection;
		wizard.init(workbench, selectionToPass);
		IDialogSettings settings =	getSettings();
		if(settings != null)
			wizard.setDialogSettings(settings);
			
		wizard.setForcePreviousAndNextButtons(true);

		// Create wizard dialog.
		Shell parent = window.getShell();
		WizardDialog dialog = new WizardDialog(parent, wizard);
		dialog.create();
		
		String title = getWizardTitle();
		if(title != null)
			wizard.setWindowTitle(title);
		
		dialog.getShell().setSize(Math.max(SIZING_WIZARD_WIDTH, dialog.getShell().getSize().x),	SIZING_WIZARD_HEIGHT);

		// Open wizard.
		dialog.open();
	}
}
