/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ToggleLinkingAction.java,v 1.4 2005/02/16 22:24:05 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.internal.navigator.action;

import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.ui.internal.util.ContextIds;
import org.eclipse.ui.help.WorkbenchHelp;

/**
 * This action toggles whether this navigator links its selection to the active
 * editor.
 * 
 * <p>This implementation is based on the 
 * {@link org.eclipse.ui.views.navigator.ToggleLinkingAction} class.
 * 
 * @author marcelop
 * @since 0.0.1
 */
public class ToggleLinkingAction 
extends NavigatorAction
{
	/**
	 * Constructor for ToggleLinkingAction
	 * @param navigator
	 * @param label
	 */
	public ToggleLinkingAction(INavigator navigator, String label)
	{
		super(navigator, label);
		setChecked(navigator.isLinkingEnabled());
		WorkbenchHelp.setHelp(this, HyadesUIPlugin.getID() + ContextIds.ACT_TOGGLE_LINK);										
	}

	/**
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	public void run()
	{
		getNavigator().setLinkingEnabled(isChecked());
	}
}
