/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: HyadesViewerSorter.java,v 1.4 2005/02/16 22:24:05 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.internal.util;

import java.text.Collator;

import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

/**
 * Extension of the {@link org.eclipse.jface.viewers.ViewerSorter} class that provides
 * an easier way to customize the comparision throught extension.
 * 
 * @author marcelop
 * @since 0.0.1
 */
public class HyadesViewerSorter 
extends ViewerSorter
{
	/**
	 * Constructor for HyadesViewerSorter
	 */
	public HyadesViewerSorter()
	{
		super();
	}

	/**
	 * Constructor for HyadesViewerSorter
	 * @param collator
	 */
	public HyadesViewerSorter(Collator collator)
	{
		super(collator);
	}

	/**
	 * @see org.eclipse.jface.viewers.ViewerSorter#compare(org.eclipse.jface.viewers.Viewer, java.lang.Object, java.lang.Object)
	 */
	public int compare(Viewer viewer, Object e1, Object e2)
	{
		int ret = compareCategories(e1, e2);
		if(ret != 0)
			return ret;

		String value1 = getValue(viewer, e1);
		if(value1 == null)
			value1 = "";
			
		String value2 = getValue(viewer, e2);
		if(value2 == null)
			value2 = "";

		return compareValues(value1, value2);
	}
	
	/**
	 * Compares e1 and e2 based on their categories.
	 * @param e1
	 * @param e2
	 * @return int
	 */
	protected int compareCategories(Object e1, Object e2)
	{
		return (category(e1)-category(e2)); 
	}
	
	/**
	 * Returns the comparison value for the specified object 
	 * @param viewer
	 * @param e
	 * @return String
	 */
	protected String getValue(Viewer viewer, Object e)
	{
		if(viewer instanceof ContentViewer)
		{
			IBaseLabelProvider prov = ((ContentViewer) viewer).getLabelProvider();
			if(prov instanceof ILabelProvider)
				return ((ILabelProvider)prov).getText(e);
		}
		
		return e.toString();		
	}
	
	/**
	 * Final comparison performed by this class.
	 * @param value1
	 * @param value2
	 * @return int
	 */
	protected int compareValues(String value1, String value2)
	{
		return collator.compare(value1, value2);
	}
}
