/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IWizardElement.java,v 1.4 2005/02/16 22:24:05 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.internal.wizard.selection;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;

/**
 * Interface to define the items that are  presented by the Selection Page.
 * 
 * <p>Implementor's are expected to be adaptable for 
 * {@link org.eclipse.ui.model.IWorkbenchAdapter} and 
 * {@link org.eclipse.jface.wizard.IWizardNode}.
 * 
 * @author marcelop
 * @since 0.2.0
 */
public interface IWizardElement
extends IAdaptable
{
	public IWizard getWizard();
	public String getId();
	public String getLabel();
	public String getDescription();
	public ImageDescriptor getImageDescriptor();
}
