/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ILogger.java,v 1.4 2005/02/16 22:24:05 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.util;

/**
 * Interface for objects that have methods to log errors or informations.
 * 
 * @author marcelop
 * @since 0.0.1
 */
public interface ILogger
{
	/**
	 * Logs an error described by a throwable.
	 * @param t
	 */
	public void logError(Throwable throwable);
	
	/**
	 * Logs an error described by a text.
	 * @param text
	 */
	public void logError(String text);
	
	/**
	 * Logs an information described by a text.
	 * @param text
	 */
	public void logInfo(String text);
}
