/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TimeBasedLogRecordCorrelationEngineImpl.java,v 1.11 2005/02/16 22:20:29 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.logc.internal.extensions;

import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.hyades.loaders.cbe.CBEUtils;
import org.eclipse.hyades.logc.LogCorrelatorPlugin;
import org.eclipse.hyades.logc.extensions.ICorrelationMonitor;
import org.eclipse.hyades.logc.extensions.ILogRecordCorrelationEngine;
import org.eclipse.hyades.logs.correlators.RecordList;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.hierarchy.CorrelationContainer;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.CorrelationEngine;

public class TimeBasedLogRecordCorrelationEngineImpl implements ILogRecordCorrelationEngine{
	
	String correlationName;
	CorrelationEngine correlationEngine;
	CorrelationContainer correlationContainer;
	
	public TimeBasedLogRecordCorrelationEngineImpl(){
	}
	
	public void correlate(CorrelationContainerProxy correlationContainerProxy,EList list, ICorrelationMonitor monitor){
		
		correlationEngine = correlationContainerProxy.getCorrelationEngine();
		correlationContainer = correlationContainerProxy.getCorrelationContainer();

		if(correlationEngine==null)
		{	
			correlationName = LogCorrelatorPlugin.getResourceString("CORR_NAME");
			correlationEngine.setType(LogCorrelatorPlugin.getResourceString("CORR_TYPE"));
			correlationEngine.setName(LogCorrelatorPlugin.getResourceString("CORR_NAME"));
			// set the ID with the type for now
			correlationEngine.setId(LogCorrelatorPlugin.getResourceString("CORR_NAME"));
		}
		int total = 0;
		
		for(int i=0; i<list.size();i++){
			if(list.get(i)!=null){
			   	   EList recordList = ((RecordList)list.get(i)).getList();
			   	   total = total + recordList.size();
			}
		}
		int count = 0;
		monitor.beginTask(correlationContainerProxy.getCorrelationEngine().getName(), total);
		String[] msg = new String[] { "0", String.valueOf(total)};
		try{
			for(int i=0; i<list.size();i++){
			   if(list.get(i)!=null){
			   	   EList recordList = ((RecordList)list.get(i)).getList();
			   	   for(int k=0; k<recordList.size(); k++){
			   	      if(recordList.get(k)!=null){

			   	      	if (monitor != null) {
			   				msg[0] = String.valueOf(++count);
			   				monitor.worked(1);
			   				monitor.subTask(LogCorrelatorPlugin.getResourceString("STR_PROCESSING_MSG", msg));
			   				if (monitor.isCanceled())
			   					throw new OperationCanceledException();
			   			 }
			   	      		   	      	
			   	      	setPartners(recordList.get(k),list,i,k, monitor, msg);
			   	      	
			   	      }
			   	   }
			   }	
			}
		}
		catch(OperationCanceledException e){
			//user has canceled the correlation activity, just return.	
		}
		monitor.done();
	}
	
	private void setPartners(Object art, EList list, int currentListIndex, int currentRecordIndex, ICorrelationMonitor monitor, String[] msg){
		
		CBECommonBaseEvent artifact = (CBECommonBaseEvent)art;
	
	   	double artifactTime = CBEUtils.computeAdjustedCreationTime(artifact);
	   	EList recordList = null;
	   	for(int i=0; i<list.size();i++){
	   		  if (i<currentListIndex) continue;
	   	      recordList = ((RecordList)list.get(i)).getList();
	   	      if(recordList != null){
	   	         for(int k=0; k<recordList.size(); k++){
		   	        if(recordList.get(k)!=null){
		   	        	
		   	           if(i>currentListIndex || (i==currentListIndex && k>currentRecordIndex)){

		   	      	      if(CBEUtils.computeAdjustedCreationTime((CBECommonBaseEvent)recordList.get(k))==artifactTime
		   	      	         && recordList.get(k)!=art){	
		   	      	      	addCorrelation((CBECommonBaseEvent)art,(CBECommonBaseEvent)recordList.get(k));		   	      	      	
		   	      	       }
	   	      	         
		   	           }
		   	        }	
	   	         }
	   	      }
	   	}
	}

	/**
	 * @param artifact
	 * @return
	 */
	private EList addCorrelation(CBECommonBaseEvent artifact,CBECommonBaseEvent associatedEvent) {
		
		EMap correlationMap  = correlationContainer.getCorrelations();
		EList correlations = null;
		synchronized(correlationMap){	
			correlations = (EList)correlationMap.get(artifact);
			if(correlations==null)
			{
				correlations = new BasicEList();
				correlations.add(associatedEvent);
				correlationContainer.getCorrelations().put(artifact,correlations);
			}
			else
			{
				correlations.add(associatedEvent);
			}
		}
		return correlations;
	}
}
