/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestUISafeRunnable.java,v 1.1 2005/03/21 17:47:42 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.ui;

import org.eclipse.core.runtime.ISafeRunnable;

/** Default safe runnable class used to wrap extender calls.
 *  Concrete classes should implement the run method that wraps the actual client call.
 * 
 * @author jgout
 * @since 3.3
 */
public abstract class TestUISafeRunnable implements ISafeRunnable {

	public void handleException(Throwable exception) {
		TestUIPlugin.logError(exception);
	}

}
