/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DPLSuggestedTypePropertySource.java,v 1.3 2005/02/16 22:22:04 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.adapter;

import org.eclipse.hyades.edit.datapool.IDatapoolSuggestedType;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource2;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

/**
 * This class is a {@link org.eclipse.ui.views.properties.IPropertySource2 IPropertySource2}
 * implemented for {@link org.eclipse.hyades.edit.datapool.IDatapoolSuggestedType IDatapoolSuggestedType}.
 * 
 * @author bjiang
 * @since  3.3
 */
public class DPLSuggestedTypePropertySource implements IPropertySource2
{
    public static final String PROPERTY_SOURCE_SUGGESTEDTYPE_TYPE = "hyades.datapool.propertySource.suggestedType.type";
	public static final String PROPERTY_SOURCE_SUGGESTEDTYPE_CLASS_NAME = "hyades.datapool.propertySource.suggestedType.className";
	public static final String PROPERTY_SOURCE_SUGGESTEDTYPE_ENUMERATIONS = "hyades.datapool.propertySource.suggestedType.enumeratedLiterals";

	private IDatapoolSuggestedType suggestedType;
	
	public DPLSuggestedTypePropertySource(IDatapoolSuggestedType type)
	{
	    this.suggestedType = type;
	}
	
    /* (non-Javadoc)
     * @see org.eclipse.ui.views.properties.IPropertySource2#isPropertyResettable(java.lang.Object)
     */
    public boolean isPropertyResettable(Object id)
    {
        return true;
    }

    /* (non-Javadoc)
     * @see org.eclipse.ui.views.properties.IPropertySource#getEditableValue()
     */
    public Object getEditableValue()
    {
        // TODO Auto-generated method stub
        return null;
    }

    /* (non-Javadoc)
     * @see org.eclipse.ui.views.properties.IPropertySource#getPropertyDescriptors()
     */
    public IPropertyDescriptor[] getPropertyDescriptors()
    {
        String[] comboValues = new String[5];
		// make the index match the value.
		comboValues[IDatapoolSuggestedType.TYPE_STRING] = IDatapoolSuggestedType.TYPE_DISPLAY_STRING;
		comboValues[IDatapoolSuggestedType.TYPE_NUMBER] = IDatapoolSuggestedType.TYPE_DISPLAY_NUMBER;
		comboValues[IDatapoolSuggestedType.TYPE_BOOLEAN] = IDatapoolSuggestedType.TYPE_DISPLAY_BOOLEAN;
		comboValues[IDatapoolSuggestedType.TYPE_ENUMERATION] = IDatapoolSuggestedType.TYPE_DISPLAY_ENUMERATION;
		comboValues[IDatapoolSuggestedType.TYPE_COMPLEX] = IDatapoolSuggestedType.TYPE_DISPLAY_COMPLEX;
        IPropertyDescriptor typePropDescriptor = new ComboBoxPropertyDescriptor(PROPERTY_SOURCE_SUGGESTEDTYPE_TYPE, "Type", comboValues);
        
        IPropertyDescriptor classNamePropDescriptor = new TextPropertyDescriptor(PROPERTY_SOURCE_SUGGESTEDTYPE_CLASS_NAME, "Class Name");
        
        return new IPropertyDescriptor[]{typePropDescriptor, classNamePropDescriptor};
    }

    /* (non-Javadoc)
     * @see org.eclipse.ui.views.properties.IPropertySource#getPropertyValue(java.lang.Object)
     */
    public Object getPropertyValue(Object id)
    {
        if(PROPERTY_SOURCE_SUGGESTEDTYPE_TYPE.equals(id))
            return new Integer(suggestedType.getSuggestedType());
        else if(PROPERTY_SOURCE_SUGGESTEDTYPE_CLASS_NAME.equals(id))
            return suggestedType.getSuggestedClassName();
        else if(PROPERTY_SOURCE_SUGGESTEDTYPE_ENUMERATIONS.equals(id))
            return suggestedType.getEnumerationLiterals();
        
        return null;
    }

    /* (non-Javadoc)
     * @see org.eclipse.ui.views.properties.IPropertySource#isPropertySet(java.lang.Object)
     */
    public boolean isPropertySet(Object id)
    {
        // TODO Auto-generated method stub
        return false;
    }

    /* (non-Javadoc)
     * @see org.eclipse.ui.views.properties.IPropertySource#resetPropertyValue(java.lang.Object)
     */
    public void resetPropertyValue(Object id)
    {
        // TODO Auto-generated method stub

    }

    /* (non-Javadoc)
     * @see org.eclipse.ui.views.properties.IPropertySource#setPropertyValue(java.lang.Object, java.lang.Object)
     */
    public void setPropertyValue(Object id, Object value)
    {
        if(PROPERTY_SOURCE_SUGGESTEDTYPE_TYPE.equals(id) && value instanceof Integer)
            suggestedType.setSuggestedType(((Integer)value).intValue());
        else if(PROPERTY_SOURCE_SUGGESTEDTYPE_CLASS_NAME.equals(id))
            suggestedType.setSuggestedClassName(value.toString());
        else if(PROPERTY_SOURCE_SUGGESTEDTYPE_ENUMERATIONS.equals(id))
            suggestedType.setEnumerationLiterals((String[])value);        
    }

}
