/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DatapoolVariablePropertySource.java,v 1.3 2005/02/16 22:22:04 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.adapter;

import org.eclipse.hyades.edit.datapool.IDatapoolVariable;
import org.eclipse.hyades.models.common.datapool.DPLVariable;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

/**
 * This class is a {@link org.eclipse.ui.views.properties.IPropertySource2 IPropertySource2}
 * implemented for {@link org.eclipse.hyades.edit.datapool.IDatapoolVariable IDatapoolVariable}.
 * 
 * @author bjiang
 * @since  3.3
 */
public class DatapoolVariablePropertySource extends NamedElementPropertySource {

	public static final String PROPERTY_SOURCE_ROLE = "datapool.variable.propertySource.role"; //$NON-NLS-1$
	public static final String PROPERTY_SOURCE_SUGGESTED_TYPE = "datapool.propertySource.suggestedType"; //$NON-NLS-1$
	//private DPLSuggestedTypePropertySource suggestedTypeSource;
	
	/**
	 * @param namedElement
	 */
	public DatapoolVariablePropertySource(IDatapoolVariable variable) {
		super(variable);
		//this.suggestedTypeSource = new DPLSuggestedTypePropertySource((IDatapoolSuggestedType)variable.getSuggestedType());
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.views.properties.IPropertySource#getPropertyDescriptors()
	 */
	public IPropertyDescriptor[] getPropertyDescriptors() {		
		//PropertyDescriptor suggestedTypePropDescriptor = new PropertyDescriptor(PROPERTY_SOURCE_SUGGESTED_TYPE, "Suggested Type");		
	    PropertyDescriptor suggestedTypePropDescriptor = new TextPropertyDescriptor(PROPERTY_SOURCE_SUGGESTED_TYPE, TestUIPlugin.getString("Word.Type")); //$NON-NLS-1$
	    suggestedTypePropDescriptor.setCategory(TestUIPlugin.getString("Word.Attributes")); //$NON-NLS-1$

		String[] comboValues = new String[5];
		comboValues[IDatapoolVariable.ROLE_UNSPECIFIED] = TestUIPlugin.getString("DatapoolEditor.VariableRoles.Unspecified"); //$NON-NLS-1$
		comboValues[IDatapoolVariable.ROLE_INPUT_DATA] = TestUIPlugin.getString("DatapoolEditor.VariableRoles.Input"); //$NON-NLS-1$
		comboValues[IDatapoolVariable.ROLE_OUTPUT_DATA] = TestUIPlugin.getString("DatapoolEditor.VariableRoles.Output"); //$NON-NLS-1$
		comboValues[IDatapoolVariable.ROLE_INPUT_OUTPUT_DATA] = TestUIPlugin.getString("DatapoolEditor.VariableRoles.InputOutput"); //$NON-NLS-1$
		comboValues[IDatapoolVariable.ROLE_VERIFICATION_DATA] = TestUIPlugin.getString("DatapoolEditor.VariableRoles.Verification"); //$NON-NLS-1$
		PropertyDescriptor rolePropDescriptor = new ComboBoxPropertyDescriptor(PROPERTY_SOURCE_ROLE, TestUIPlugin.getString("DatapoolEditor.VariableRoles.Role"), comboValues); //$NON-NLS-1$
		rolePropDescriptor.setCategory(TestUIPlugin.getString("Word.Attributes")); //$NON-NLS-1$
		
		IPropertyDescriptor[] temp = new IPropertyDescriptor[]{suggestedTypePropDescriptor, rolePropDescriptor};
		IPropertyDescriptor[] superDescriptors = super.getPropertyDescriptors();
		IPropertyDescriptor[] descriptors = new IPropertyDescriptor[temp.length + superDescriptors.length];
		System.arraycopy(temp, 0, descriptors, 0, temp.length);
		System.arraycopy(superDescriptors, 0, descriptors, temp.length, superDescriptors.length);
		
		superDescriptors = null;
		temp = null;	
		
		return descriptors;
	}
	
	public Object getPropertyValue(Object id) {
		if(PROPERTY_SOURCE_SUGGESTED_TYPE.equals(id))
			// can't use IDatapoolSuggestedType until it's part of the data model
		    //return ((IDatapoolSuggestedType)variable.getSuggestedType()).getSuggestedClassName();
		    return ((DPLVariable)getNamedElement()).getType();
		else if(PROPERTY_SOURCE_ROLE.equals(id))
			return new Integer(((DPLVariable)getNamedElement()).getRoleAsInt());
		else
			return super.getPropertyValue(id);
	}
	public void setPropertyValue(Object id, Object value) {
		if(PROPERTY_SOURCE_SUGGESTED_TYPE.equals(id))
		    // can't use IDatapoolSuggestedType until it's part of the data model
			//((IDatapoolSuggestedType)variable.getSuggestedType()).setSuggestedClassName((String)value);
		    ((DPLVariable)getNamedElement()).setType((String)value);
		else if(PROPERTY_SOURCE_ROLE.equals(id) && value instanceof Integer)
		    ((IDatapoolVariable)getNamedElement()).setRole(((Integer)value).intValue());
		else
			super.setPropertyValue(id, value);
	}
}
