/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ResourceSetFileAdaptable.java,v 1.4 2005/02/16 22:22:04 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.adapter;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.resource.ResourceSet;

/**
 * Implementation of the 
 * {@link org.eclipse.hyades.test.ui.adapter.IResourceSetFileAdaptable}.
 * 
 * @author marcelop
 * @since 0.2.0
 */
public class ResourceSetFileAdaptable 
implements IResourceSetFileAdaptable
{
	private ResourceSet resourceSet;
	private IFile file;
	
	/**
	 * Constructor for ResourceSetFileAdaptable
	 * @param resourceSet
	 * @param file 
	 */
	public ResourceSetFileAdaptable(ResourceSet resourceSet, IFile file)
	{
		this.resourceSet = resourceSet;
		this.file = file;
	}

	/**
	 * @see org.eclipse.hyades.test.ui.adapter.IResourceSetAdaptable#getResourceSet()
	 */
	public ResourceSet getResourceSet()
	{
		return resourceSet;
	}

	/**
	 * @see org.eclipse.hyades.test.ui.adapter.IResourceSetAdaptable#getFile()
	 */
	public IFile getFile()
	{
		return file;
	}

	/**
	 * @see org.eclipse.core.runtime.IAdaptable#getAdapter(java.lang.Class)
	 */
	public Object getAdapter(Class adapter)
	{
		return Platform.getAdapterManager().getAdapter(this, adapter);
	}

}
