/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DefaultTestContextOverviewContribution.java,v 1.6 2005/02/16 22:22:05 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.editor.form;

import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.editor.form.util.NamedElementsSection;
import org.eclipse.hyades.test.ui.internal.action.AddDatapoolAction;
import org.eclipse.hyades.test.ui.internal.action.EditDatapoolAction;
import org.eclipse.hyades.test.ui.internal.action.DeleteDatapoolAction;
import org.eclipse.hyades.test.ui.editor.form.util.ExtensibleEObjectTableSection;
import org.eclipse.hyades.ui.editor.IEditorExtension;
import org.eclipse.jface.action.IAction;


/**
 * @author bcormier
 * @since 3.0.0
 */
public class DefaultTestContextOverviewContribution extends
        TestContextOverviewContribution {

    private DeleteDatapoolAction removeBtn;
    
    /**
     * This method is called by TestContextOverview to create the content of the column on the left.
     * @param editorExtension the editor extension.
     * @return an array of form sections which describe the content of the column on the left.
     * @see org.eclipse.hyades.test.ui.editor.form.TestContextOverviewContribution#createLeftSections(org.eclipse.hyades.ui.editor.IEditorExtension)
     */
    protected Object[] createLeftSections(
            IEditorExtension editorExtension) {
        NamedElementsSection testCasesSection = new NamedElementsSection(editorExtension, 1);
        testCasesSection.setDescription(TestUIPlugin.getString("EDT_TST_CASE_DSC")); //$NON-NLS-1$
        testCasesSection.setHeaderText(TestUIPlugin.getString("W_TST_CASES")); //$NON-NLS-1$
        return new NamedElementsSection[] {testCasesSection};
    }
    
    /**
     * This method is called by TestContextOverview to create the content of the column on the right.
     * @param editorExtension the editor extension.
     * @return an array of form sections which describe the content of the column on the left.
     * @see org.eclipse.hyades.test.ui.editor.form.TestContextOverviewContribution#createRightSections(org.eclipse.hyades.ui.editor.IEditorExtension)
     */
    protected Object[] createRightSections(IEditorExtension editorExtension) {
        AddDatapoolAction addBtn = new AddDatapoolAction();
        EditDatapoolAction editBtn = new EditDatapoolAction();
        removeBtn = new DeleteDatapoolAction();
               
        ExtensibleEObjectTableSection datapoolSection = new ExtensibleEObjectTableSection(
                getOverviewForm(), 
                Common_TestprofilePackage.eINSTANCE.getTPFTestSuite_Datapools(),
                1,
                new IAction[] {addBtn, editBtn, removeBtn});
        datapoolSection.setCollapsable(true);
        datapoolSection.setHeaderText(TestUIPlugin.getString("W_DATAPOOL")); //$NON-NLS-1$
        addBtn.setTable(datapoolSection);
        return new Object[] {datapoolSection};
    }
    
    /**
     * This method is used to initialize the sections that belong to the column on the left.
     * @param leftSections the sections in the order in which they have been created thanks to createLeftSections(IEditorExtension editorExtension).
     * @see org.eclipse.hyades.test.ui.editor.form.TestContextOverviewContribution#initializeLeftSections(org.eclipse.hyades.test.ui.editor.form.util.NamedElementsSection[])
     */
    protected void initializeLeftSections(Object[] leftSections) {
        if (leftSections==null || leftSections.length!=1) 
            return;
        
        // leftSections[0] should be a test cases section
        if (leftSections[0] instanceof NamedElementsSection)
            ((NamedElementsSection)leftSections[0]).initialize(
                getTestContext(), 
                Common_TestprofilePackage.eINSTANCE.getTPFTestSuite_TestCases(),
                TestUIPlugin.getString("W_TST_CASES")); //$NON-NLS-1$
    }
    
    /**
     * This method is used to initialize the sections that belong to the column on the left.
     * @param leftSections the sections in the order in which they have been created thanks to createLeftSections(IEditorExtension editorExtension).
     * @see org.eclipse.hyades.test.ui.editor.form.TestContextOverviewContribution#initializeRightSections(org.eclipse.hyades.test.ui.editor.form.util.NamedElementsSection[])
     */
    protected void initializeRightSections(Object[] rightSections) {
        if (rightSections==null || rightSections.length!=1) 
            return;
        if (rightSections[0] instanceof ExtensibleEObjectTableSection) {
            ((ExtensibleEObjectTableSection)rightSections[0]).initialize(getTestContext());
            removeBtn.setTestSuite(getTestContext());
        }

    }
}
