/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestContextOverviewContribution.java,v 1.7 2005/02/16 22:22:05 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.editor.form;

import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.ui.editor.IEditorExtension;
import org.eclipse.swt.widgets.Composite;


/**
 * This class contributes to the overview of a test context editor.
 * <pre>
 *    _______________________  
 *   | Test Context Editor   |
 *   |_______________________|________________________________________________________ 
 *   |                                                                                |
 *   |  _ General Information __________      _ form2 overview _____________________  |
 *   | |                                |    |                                      | |
 *   | |                                |    |                                      | |
 *   | |                                |    |                                      | |
 *   | |                                |    |______________________________________| |
 *   | |                                |                                             |
 *   | |________________________________|     _ form4 overview _____________________  |
 *   |                                       |                                      | |
 *   |  _ Test Objective _______________     |                                      | |
 *   | |                                |    |                                      | |
 *   | |                                |    |                                      | |
 *   | |                                |    |                                      | |
 *   | |                                |    |                                      | |
 *   | |                                |    |______________________________________| |
 *   | |________________________________|                                             |
 *   |                                                                                |
 *   |  _ form1 overview _______________                                              |
 *   | |                                |                                             |
 *   | |                                |                                             |
 *   | |________________________________|                                             |
 *   |                                                                                |
 *   |________________________________________________________________________________|
 *   |_Overview_|form1| form2 | form3 | form4 |                                       | 
 * </pre>
 * 
 * Among other services, this class allows to chose wether or not the general information
 * and the test objective sections should be diplayed; it also creates the content of the
 * left and right columns (forms overviews).
 * 
 * @author bcormier
 * @since 3.0.0
 */
public class TestContextOverviewContribution {
    protected TestContextOverview overviewForm;
    protected TPFTestSuite testContext;

    /**
     * Returns the test context.
     * @return the test context.
     */
    protected TPFTestSuite getTestContext() {
        return testContext;
    }
    
    /**
     * Stores the test context.
     * @param testContext
     */
    protected void setTestContext(TPFTestSuite testContext) {
        this.testContext = testContext;
    }
    
    /**
     * Adds some information at the bottom of the generic information section.
     * @param genericInfoComposite the composite which represents the generic information section.
     * @param widgetFactory the widget factory which has been used to create the widgets within genericInfoComposite.
     */
    protected void addSouthGenericInformation(Composite genericInfoComposite, WidgetFactory widgetFactory) {
        
    }
    
    /**
     * Used to initialize the information that might been added at the bottom of the generic information section. 
     */
    protected void initializeSouthGenericInformation() {
        
    }
    
    /**
     * Adds some information after the name of the test suite in the generic information section.
     * @param genericInfoComposite the composite which represents the generic information section.
     * @param widgetFactory the widget factory which has been used to create the widgets within genericInfoComposite.
     */
    protected void addCenterGenericInformation(Composite genericInfoComposite, WidgetFactory widgetFactory) {
        
    }
    
    /**
     * Used to initialize the information that might been added after the name of the test suite in the generic information section. 
     */
    protected void initializeCenterGenericInformation() {
        
    }  
    
    /**
     * This method is called by TestContextOverview to create the content of the column on the left.
     * The generated objects should be classes extending FormSection.
     * @param editorExtension the editor extension.
     * @return an array of form sections which describe the content of the column on the left.
     */
    protected Object[] createLeftSections(IEditorExtension editorExtension) {
        return new Object[0];
    }
    
    /**
     * This method is called by TestContextOverview to create the content of the column on the right.
     * The generated objects should be classes extending FormSection.
     * @param editorExtension the editor extension.
     * @return an array of form sections which describe the content of the column on the right.
     */
    protected Object[] createRightSections(IEditorExtension editorExtension) {
        return new Object[0];
    }
    
    /**
     * This method is used to initialize the sections that belong to the column on the left.
     * @param leftSections the sections in the order in which they have been created thanks to createLeftSections(IEditorExtension editorExtension).
     */
    protected void initializeLeftSections(Object[] leftSections) {
        
    }
    
    /**
     * This method is used to initialize the sections that belong to the column on the right.
     * @param rightSections the sections in the order in which they have been created thanks to createRightSections(IEditorExtension editorExtension).
     */
    protected void initializeRightSections(Object[] rightSections) {
        
    }
    
    /**
     * This method should be used to dispose all the widgets that have been created in this class.
     */
    protected void dispose() {
        
    }
    
    /**
     * Used to choose wether or not the generic information section should be displayed.
     * @return false if the generic information should be displayed. Otherwise, true.
     */
    protected boolean hideGenericInformation() {
        return false;
    }
    
    /**
     * Used to choose wether or not the test objective section should be displayed.
     * @return false if the test objective section should be displayed. Otherwise, true.
     */
    protected boolean hideTestObjectiveSection() {
	    return false;
	}

    /**
     * @return Returns the overviewForm.
     */
    protected TestContextOverview getOverviewForm() {
        return overviewForm;
    }
    
    /**
     * @param overviewForm The overviewForm to set.
     */
    protected void setOverviewForm(TestContextOverview overviewForm) {
        this.overviewForm = overviewForm;
    }
}
