/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AddDeploymentChildAction.java,v 1.4 2005/02/16 22:22:05 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.action;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.help.WorkbenchHelp;

import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.model.ui.AddChildAction;
import org.eclipse.hyades.test.ui.internal.util.ContextIds;

/**
 * @author marcelop
 * @since 0.3.0
 */
public class AddDeploymentChildAction 
extends AddChildAction
{
	/**
	 * Constructor for AddDeploymentChildAction
	 * @param text
	 */
	public AddDeploymentChildAction(String text)
	{
		super(Common_TestprofilePackage.eINSTANCE.getTPFDeployment(), text);
		WorkbenchHelp.setHelp(this, TestUIPlugin.getID() + ContextIds.ADD_DEP_ACT);				
	}

	/**
	 * Sets the default deployment that is returned by 
	 * {@link #getDeployment(IStructuredSelection)}.  If <code>null</code> then the
	 * selection is analysed in order to identify the deployment.
	 * @param testSuite
	 */
	public void setDeployment(TPFDeployment deployment)
	{
		setParent(deployment);
	}

	/**
	 * Returns the deployment associated with the first element of the structured 
	 * selection or <code>null</code>.
	 * @param structuredSelection
	 * @return TPFDeployment
	 */
	protected TPFDeployment getDeployment(IStructuredSelection structuredSelection)
	{
		return (TPFDeployment)getParent(structuredSelection);
	}	
}
