/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AddSUTAction.java,v 1.5 2005/02/16 22:22:05 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.action;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.help.WorkbenchHelp;

import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.util.ContextIds;
import org.eclipse.hyades.test.ui.internal.wizard.SUTNewWizard;

/**
 * @author marcelop
 * @since 0.2.0
 */
public class AddSUTAction 
extends AddTestSuiteChildAction
{
	/**
	 * Constructor for AddTestComponentAction
	 */
	public AddSUTAction()
	{
		super(TestUIPlugin.getString("BTN_ADD")); //$NON-NLS-1$
		
		setToolTipText(TestUIPlugin.getString("ACT_SUT_ADD_TIP")); //$NON-NLS-1$
		setImageDescriptor(TestUIImages.INSTANCE.getImageDescriptor(TestUIImages.IMG_SUT));
		WorkbenchHelp.setHelp(this, TestUIPlugin.getID() + ContextIds.ADD_SUT_ACT);						
	}

	/**
	 * @see org.eclipse.ui.actions.SelectionListenerAction#updateSelection(org.eclipse.jface.viewers.IStructuredSelection)
	 */
	protected boolean updateSelection(IStructuredSelection structuredSelection)
	{
		setActionPerformed(false);
		return (getTestSuite(structuredSelection) != null);
	}
	
	/**
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	public void run()
	{
		setActionPerformed(false);
		
		TPFTestSuite testSuite = getTestSuite(getStructuredSelection());
		SUTNewWizard sutNewWizard = new SUTNewWizard();
		sutNewWizard.setWindowTitle(TestUIPlugin.getString("WIZ_SUT_TTL")); //$NON-NLS-1$

		openWizard(testSuite, sutNewWizard, "SUTWizard"); //$NON-NLS-1$
	}	
}
