/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DatapoolEquivalenceClassSelectionAction.java,v 1.3 2005/02/16 22:22:05 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.action;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.edit.datapool.IDatapoolEquivalenceClass;
import org.eclipse.hyades.edit.datapool.INamedElement;
import org.eclipse.hyades.test.ui.adapter.NamedElementPropertySource;
import org.eclipse.jface.viewers.IStructuredSelection;

/**
 * This class provides common functions used by datapool actions to manipulate
 * <i>Equivalence Classes</i>.
 * 
 * @author bjiang
 * @since  3.3
 */
public class DatapoolEquivalenceClassSelectionAction extends DatapoolChildrenSelectionAction
{
    /**
     * 
     * @param datapool
     * @param text
     */
    public DatapoolEquivalenceClassSelectionAction(IDatapool datapool, String text)
    {
        super(datapool, text);
    }
    
	/* (non-Javadoc)
     * @see org.eclipse.hyades.test.ui.internal.action.DatapoolChildrenSelectionAction#getChildren()
     */
    protected List getChildren()
    {
        int count = getParent().getEquivalenceClassCount();
        ArrayList children = new ArrayList();
        for(int i = 0; i < count; i++)
            children.add(getParent().getEquivalenceClass(i));
        
        return children;
    }
    
    /* (non-Javadoc)
     * @see org.eclipse.hyades.test.ui.internal.action.DatapoolChildrenSelectionAction#getSelectionIndex()
     */
    protected int getSelectionIndex()
    {
        int index = -1;
        IStructuredSelection selection = getStructuredSelection();
        if(!selection.isEmpty() && selection.getFirstElement() instanceof NamedElementPropertySource)
        {
            INamedElement element = ((NamedElementPropertySource)selection.getFirstElement()).getNamedElement();
            if(getChildren().contains(element))
                index = getParent().getEquivalenceClassIndexById(((IDatapoolEquivalenceClass)element).getId());
        }
        return index;
    }
}
