/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: EditDatapoolAction.java,v 1.4 2005/02/16 22:22:05 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.action;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.common.datapool.DPLDatapool;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.part.FileEditorInput;


/**
 * This IAction is used to display a datapool through the Datapool Editor.
 * @author bcormier
 * @since 3.0.0
 */
public class EditDatapoolAction extends SelectionListenerAction {

    /**
     * The constructor for the class
     */
    public EditDatapoolAction() {
        super(TestUIPlugin.getString("label.Update")); //$NON-NLS-1$
    }

    
    /**
     * @see org.eclipse.ui.actions.BaseSelectionListenerAction#updateSelection(org.eclipse.jface.viewers.IStructuredSelection)
     */
    protected boolean updateSelection(IStructuredSelection selection) {
		if (selection == null) 
			return false;
		
		if (selection.size() != 1)
		    return false;
		
		if (!(selection.getFirstElement() instanceof DPLDatapool))
		    return false;
		
		return true;
    }
    
    /**
     * @see org.eclipse.jface.action.IAction#run()
     */
    public void run() {
        IStructuredSelection selection = getStructuredSelection();
        if (selection == null)
            return;
        
        // There should be only one datapool selected according to updateSelection
        DPLDatapool datapool = (DPLDatapool)selection.getFirstElement();
        if (datapool == null)
            return;
        
        // Get the resource file corresponding to the datapool 
        Resource resource = datapool.eResource();
        if (resource == null)
            return;

        try {
            // Select the active workbench page to launch the editor
	        IWorkbenchPage page = Workbench.getInstance().getActiveWorkbenchWindow().getActivePage();
	        
	        // Cast the resource file to an IFile
	        Path path = new Path(resource.getURI().toFileString());
	        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(path);
	        if (!file.exists())
	            return;
	        
	        // Launch the editor
            IEditorDescriptor desc = Workbench.getInstance().getEditorRegistry().getDefaultEditor(resource.getURI().toFileString());
            if (desc == null)
                return;
            page.openEditor(new FileEditorInput(file), desc.getId());
        } catch (Throwable e) {
            e.printStackTrace();
        }        
    }
}
