/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: RemoveVariableAction.java,v 1.4 2005/03/01 18:55:39 bjiang Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.action;

import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.jface.viewers.IStructuredSelection;

/**
 * This class handles <i>Remove</i> action in datapool editor to remove a
 * <i>Variable</i> (column).
 * 
 * @author bjiang
 * @since  3.3
 */
public class RemoveVariableAction extends DatapoolVariableSelectionAction
{
	/**
	 * 
	 * @param datapool
	 * @param text
	 */
	public RemoveVariableAction(IDatapool datapool, String text) {
		super(datapool, text);
	}
	
	/* (non-Javadoc)
     * @see org.eclipse.hyades.test.ui.internal.action.DatapoolChildrenSelectionAction#updateSelection(org.eclipse.jface.viewers.IStructuredSelection)
     */
    protected boolean updateSelection(IStructuredSelection selection)
    {
        if(!super.updateSelection(selection))
            return false;
        
        return (getParent().getVariableCount() < 2) ? false : true;
    }
	
	public void run() {
	    if(getParent().getVariableCount() < 2)
	        return;
	    
		int index = getSelectionIndex();
		if(index > -1)
		{
			getParent().removeVariable(index);
		}
	}
}
