/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DatapoolEditorPart.java,v 1.4 2005/02/16 22:22:05 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.datapool.DPLDatapool;
import org.eclipse.hyades.models.common.util.ICommonConstants;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.extension.IAssociationMapping;


/**
 * Concrete implementation of IHyadesEditorPart customized for
 * handling Hyades objects stored in resources with file extension equals to 
 * {@link org.eclipse.hyades.test.ui.TestUI#DATAPOOL_FILE_EXTENSION}.
 * 
 * @author psun
 * @since 0.0.1
 */
public class DatapoolEditorPart extends BaseEditorPart {

	/**
	 * Constructor for DeploymentEditorPart
	 */
	public DatapoolEditorPart()
	{
		super(DPLDatapool.class);
	}
	
	/**
	 * @see org.eclipse.hyades.ui.editor.IHyadesEditorPart#getFileExtension()
	 */
	public String getFileExtension()
	{
		return ICommonConstants.DATAPOOL_FILE_EXTENSION;
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.EMFEditorPart#identifyEditorDescriptor(org.eclipse.emf.ecore.EObject)
	 */
	protected IAssociationDescriptor identifyEditorDescriptor(EObject eObject)
	{
		IAssociationMapping editorAssociationMapping = TestUIExtension.getDatapoolMappingRegistry().getAssociationMapping(HyadesUIPlugin.EP_EDITOR_EXTENSIONS);
		return editorAssociationMapping.getDefaultAssociationDescriptor();
	}

}
