/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DeploymentEditorExtension.java,v 1.9 2005/02/16 22:22:05 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.extension;

import java.util.Vector;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.hyades.models.common.configuration.CFGArtifact;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.ArtifactLocationMapForm;
import org.eclipse.hyades.test.ui.internal.editor.form.ConfigurableObjectOverviewForm;
import org.eclipse.hyades.test.ui.internal.editor.form.DeploymentForm;
import org.eclipse.jface.viewers.IStructuredSelection;

/**
 * Hyades deployment editor extension that is suitable for {@link TPFDeployment} objects.
 * 
 * <p>This class is used whenever it is not possible neither to identify nor
 * to locate the appropriate extension editor.
 * 
 * @author marcelop
 * @since 0.0.1
 * @author bjiang 
 * @since	1.3
 */
public class DeploymentEditorExtension
extends ConfigurableObjectEditorExtension
{
	public static final String EXTENSION_ID = "org.eclipse.hyades.test.ui.editor.extension.Deployment"; //$NON-NLS-1$
	public static final String EDITOR_OBJECT_TYPE = "org.eclipse.hyades.models.common.testprofile.TPFDeployment";
	
	private static final int PAGE_PAIRS = 1;	
	private ArtifactLocationMapForm mapForm;
	
	/**
	 * @see org.eclipse.hyades.ui.util.IDisposable#dispose()
	 */
	public void dispose()
	{
		if(mapForm != null)
		{
			mapForm.dispose();
			mapForm = null;
		}	
		super.dispose();
	}
	
	protected IConfigurationElement[] collectRegisteredExtensionElements() 
	{
		IConfigurationElement[] extensions = super.collectRegisteredExtensionElements();		
		Vector registeredExts = new Vector();		 
		{
			for( int i = 0; i < extensions.length; i++ )
			{
			   if( extensions[i].getAttribute("appliesTo").equals(EDITOR_OBJECT_TYPE)) //$NON-NLS-1$
			   {
				   registeredExts.add( extensions[i] );
			   }
			}
		}		
		
		if( extensions.length == registeredExts.size() )
			return extensions;
	
		IConfigurationElement[] registeredExtensions = new IConfigurationElement[registeredExts.size()];
		for( int i = 0; i < registeredExts.size(); i++ )
		{
			registeredExtensions[i] = (IConfigurationElement)registeredExts.get(i);
		}
		return registeredExtensions;
	}
	
	/**
	 * @see org.eclipse.hyades.ui.editor.IEditorExtension#createPages()
	 */
	protected ConfigurableObjectOverviewForm createOverviewPage(WidgetFactory widgetFactory)
	{
		DeploymentForm overviewForm = new DeploymentForm(this, widgetFactory);
		overviewForm.setLocationPageIndex(PAGE_PAIRS); 
		return overviewForm;
	}
		
	protected void createOtherStaticPages(WidgetFactory widgetFactory)
	{
		// insert a new form of its own which is after the overview form and before any pages added by extensions.
		mapForm = new ArtifactLocationMapForm(this, widgetFactory);
		getHyadesEditorPart().addPage(mapForm.createControl());
		getHyadesEditorPart().setPageText(PAGE_PAIRS, TestUIPlugin.getString("W_PAIRS")); //$NON-NLS-1$
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.internal.editor.IExtensibleEditorExtension#activateExtensionPage(org.eclipse.core.runtime.IConfigurationElement)
	 */
	public int addExtensionPage(IConfigurationElement extensionElement) 
	{
		// if this extension element is not intended for this editor, return -1.
		if( !extensionElement.getAttribute("appliesTo").equals(EDITOR_OBJECT_TYPE)) //$NON-NLS-1$
			return -1;
		    
		return super.addExtensionPage(extensionElement);
	}
	
	/**
	 * @see org.eclipse.hyades.ui.util.IRefreshable#refreshContent(java.lang.Object)
	 */
	public void refreshContent(Object data)
	{
		super.refreshContent(data);
		
		mapForm.load();
		mapForm.updateTitle();
	}

	/**
	 * @see org.eclipse.hyades.ui.editor.IEditorExtension#getSelection()
	 */
	public IStructuredSelection getSelection()
	{
		if(PAGE_PAIRS == getHyadesEditorPart().getActivePage())
			return (IStructuredSelection)mapForm.getSelection();
		else
			return super.getSelection();
	}
	
	/**
	 * @see org.eclipse.hyades.ui.editor.IEditorExtension#pageActivated(int)
	 */
	public boolean pageActivated(int index)
	{
		if(index == PAGE_PAIRS)
			return mapForm.activated();
		else
			return super.pageActivated(index);
	}

	/**
	 * @see org.eclipse.hyades.ui.editor.IEditorExtension#setSelection(org.eclipse.jface.viewers.IStructuredSelection)
	 */
	public void setSelection(IStructuredSelection structuredSelection)
	{
		super.setSelection(structuredSelection);
		
		if(structuredSelection.size() == 1)
		{
			Object object = structuredSelection.getFirstElement();
			if(object instanceof TPFDeployment)
			{
				getHyadesEditorPart().setActivePage(PAGE_OVERVIEW);
				getOverviewForm().selectReveal(structuredSelection);
			}
			else if(object instanceof CFGLocation)
			{
				getHyadesEditorPart().setActivePage(PAGE_PAIRS);
				mapForm.selectReveal(structuredSelection);
			}
			else if(object instanceof CFGArtifact)
			{
				getHyadesEditorPart().setActivePage(PAGE_PAIRS);
				mapForm.selectReveal(structuredSelection);
			}
		}
	}	
}
