/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ConfigurableObjectOverviewForm.java,v 1.11 2005/04/07 21:29:03 bjiang Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form;

import java.util.Enumeration;
import java.util.Hashtable;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.configuration.CFGConfigurableObject;
import org.eclipse.hyades.models.common.configuration.CFGPropertyGroup;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.editor.form.util.NamedElementsSection;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.extension.ConfigurableObjectEditorExtension;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormSection;
import org.eclipse.hyades.test.ui.internal.editor.form.util.GeneralInfoSection;
import org.eclipse.hyades.test.ui.internal.editor.form.util.RegisteredExtensionsSection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.model.IWorkbenchAdapter;

/**
 * This class provides a base implementation for {@link CFGConfigurableObject} editor overview page.
 * 
 * @author bjiang
 * @since  1.3
 */
public class ConfigurableObjectOverviewForm extends EditorForm 
{	
	private FormSection generalInfoSection;
	private IConfigurationElement[] registeredExtensions;
	private RegisteredExtensionsSection registeredExtensionsSection;
	private Hashtable propGroupSectionsMap = new Hashtable();
	private Composite leftColumnContainer;
	private Composite rightColumnContainer;
	
	/**
	 * Constructor for ConfigurableObjectOverviewForm
	 * @param editorExtension
	 * @param widgetFactory
	 */
	public ConfigurableObjectOverviewForm(ConfigurableObjectEditorExtension editorExtension, WidgetFactory widgetFactory)
	{
		super(editorExtension, widgetFactory);
	}
	
	/**
	 * @see org.eclipse.update.ui.forms.internal.IForm#dispose()
	 */
	public void dispose()
	{
		if(generalInfoSection != null)
		{
			generalInfoSection.dispose();
			generalInfoSection = null;
		}
		Enumeration enum = propGroupSectionsMap.elements();
		NamedElementsSection section;
		while(enum.hasMoreElements())
		{
			section = (NamedElementsSection)enum.nextElement();
			if(section != null)
			{
				section.dispose();
				section = null;
			}
		}
		propGroupSectionsMap.clear();
		propGroupSectionsMap = null;
	
		super.dispose();
	}
	
	protected Composite getRightColumnContainer()
	{
		return this.rightColumnContainer;
	}
	
	protected Composite getLeftColumnContainer()
	{
		return this.leftColumnContainer;
	}
	
	protected FormSection getGeneralInfoSection()
	{
		return this.generalInfoSection;
	}
	
	protected void setGeneralInfoSection(FormSection section)
	{
		this.generalInfoSection = section;
	}
	
	/**
	 * Returns the data object that is manipulated by this editor.
	 * @return EObject 
	 */
	protected EObject getDataObject()
	{
		return ((ConfigurableObjectEditorExtension)getBaseEditorExtension()).getEditorObject();
	}
	
	public void setRegisteredExtensions(IConfigurationElement[] extensions)
	{
		this.registeredExtensions = extensions;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.util.EditorForm#createEditorFormContents(org.eclipse.swt.widgets.Composite)
	 */
	protected void createEditorFormContents(Composite parent) 
	{
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 2;
		gridLayout.makeColumnsEqualWidth = true;
		gridLayout.marginWidth = 10;
		gridLayout.horizontalSpacing = 15;
		parent.setLayout(gridLayout);
		Control control;

		leftColumnContainer = createColumn(parent);		
		rightColumnContainer = createColumn(parent);
		
		createGeneralInfoSection(leftColumnContainer);			
		createRegisteredExtensionsSection(leftColumnContainer);
	}

	protected void createGeneralInfoSection(Composite parent) 
	{
		Control control;
		generalInfoSection = new GeneralInfoSection(this, true);
		((GeneralInfoSection)generalInfoSection).setEditable(true);
		registerSection(generalInfoSection);		
		control = generalInfoSection.createControl(parent, getWidgetFactory());
		GridData gridData = new GridData(GridData.FILL_HORIZONTAL | GridData.VERTICAL_ALIGN_BEGINNING);
		control.setLayoutData(gridData);		
		setGeneralInfoSectionHelp(control);
	}
	
	protected void setGeneralInfoSectionHelp(Control control)
	{
	}
	
	protected void createRegisteredExtensionsSection(Composite parent)
	{
		registeredExtensionsSection = new RegisteredExtensionsSection((ConfigurableObjectEditorExtension)getBaseEditorExtension(), registeredExtensions);
		registerSection(registeredExtensionsSection);
		Control control = registeredExtensionsSection.createControl(parent, getWidgetFactory());
		registeredExtensionsSection.setHeaderText( TestUIPlugin.getString("EDT_REGISTERED_PROP_GROUPS") ); //$NON-NLS-1$
		registeredExtensionsSection.setDescription( TestUIPlugin.getString("EDT_REG_PROP_GRP_DSC") ); //$NON-NLS-1$
		control.setLayoutData(new GridData(GridData.FILL_HORIZONTAL | GridData.VERTICAL_ALIGN_BEGINNING));

	}
	
	public void addSection(IPropertyGroupForm extensionForm, int pageIndex)
	{				
		NamedElementsSection section = new NamedElementsSection(getBaseEditorExtension(), pageIndex);
		registerSection(section);
		section.createControl(rightColumnContainer, getWidgetFactory(), extensionForm.getName(), extensionForm.getDescription());
	
		CFGPropertyGroup propertyGroup = extensionForm.getPropertyGroup(); 
		propGroupSectionsMap.put(propertyGroup, section);
		section.initialize(propertyGroup, Common_ConfigurationPackage.eINSTANCE.getCFGPropertyGroup_Properties(), null);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.util.EditorForm#load()
	 */
	public void load() 
	{
		((GeneralInfoSection)generalInfoSection).setInput(getDataObject());
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.common.EditorForm#updateTitle()
	 */
	public void updateTitle()
	{
		String title = ((IWorkbenchAdapter)((IAdaptable)getDataObject()).getAdapter(IWorkbenchAdapter.class)).getLabel(getDataObject());
		if(title != null)
			getBaseEditorExtension().getHyadesEditorPart().setTitle(title);
	}
	
	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.common.EditorForm#activated()
	 */
	public boolean activated()
	{
		return true;
	}
}
