/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DataTableForm.java,v 1.14 2005/02/16 22:22:05 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form;

import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.edit.datapool.IDatapoolFactory;
import org.eclipse.hyades.edit.datapool.IDatapoolListener;
import org.eclipse.hyades.edit.datapool.IDatapoolEquivalenceClass;
import org.eclipse.hyades.models.common.datapool.DPLDatapool;
import org.eclipse.hyades.models.common.datapool.impl.Common_DatapoolFactoryImpl;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.datapool.internal.control.DatapoolTable;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.extension.DatapoolEditorExtension;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.internal.util.ContextIds;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.help.WorkbenchHelp;

/**
 * This class defines the <i>Data Table</i> tab in datapool editor.
 * 
 * @author psun
 * @author bjiang
 */
public class DataTableForm extends EditorForm implements IDatapoolListener{

	IDatapoolEquivalenceClass datapoolEquivalenceClass;
	DatapoolTable table = null;
	
	/**
	 * Constructor for DataTableForm
	 * @param datapoolEditorExtension
	 * @param widgetFactory
	 */
	public DataTableForm(DatapoolEditorExtension datapoolEditorExtension, WidgetFactory widgetFactory, IDatapoolEquivalenceClass datapoolEquivalenceClass)
	{
		super(datapoolEditorExtension, widgetFactory);
		setHeadingText(TestUIPlugin.getString("W_DATAPOOL")); //$NON-NLS-1$
		this.datapoolEquivalenceClass = datapoolEquivalenceClass;
	}

	/**
	 * @see org.eclipse.update.ui.forms.internal.IForm#dispose()
	 */
	public void dispose()
	{
		if(table != null)
		{
		    table.dispose();
		    table = null;
		}
		super.dispose();
	}

	/**
	 * Returns the datapool manipulated by this form.
	 * @return DPLDatapool
	 */
	protected DPLDatapool getDatapool()
	{
		return ((DatapoolEditorExtension)getBaseEditorExtension()).getDatapool();		
	}
	
	public IDatapoolEquivalenceClass getDatapoolEquivalenceClass()
	{
		return this.datapoolEquivalenceClass;
	}

	public Control createControl()
	{
		Control control = super.createControl();
		WorkbenchHelp.setHelp(getControl(), TestUIPlugin.getID() + ContextIds.DATA_TABLE_FORM);
		return control;
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.common.EditorForm#createEditorFormContents(org.eclipse.swt.widgets.Composite)
	 */
	protected void createEditorFormContents(Composite parent)
	{
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 1;
		gridLayout.makeColumnsEqualWidth = true;
		gridLayout.marginWidth = 10;
		//gridLayout.horizontalSpacing = 15;
		parent.setLayout(gridLayout);
		
		table = new DatapoolTable(parent, 
									(DatapoolEditorExtension)getBaseEditorExtension(),
									datapoolEquivalenceClass,
									(IDatapoolFactory)Common_DatapoolFactoryImpl.eINSTANCE, 
									TestUIPlugin.getString("HYADES"));
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.util.EditorForm#load()
	 */
	public void load() 
	{
		table.refresh(datapoolEquivalenceClass);
	}
	
	
    /* (non-Javadoc)
     * @see org.eclipse.hyades.edit.datapool.IDatapoolListener#cellChanged(org.eclipse.hyades.edit.datapool.IDatapool, int, int, int)
     */
    public void cellChanged(IDatapool datapool, int equivalenceClassIndex,
            int recordIndex, int variableIndex)
    {
        // TODO Auto-generated method stub

    }
    /* (non-Javadoc)
     * @see org.eclipse.hyades.edit.datapool.IDatapoolListener#equivalenceClassAdded(org.eclipse.hyades.edit.datapool.IDatapool, int)
     */
    public void equivalenceClassAdded(IDatapool datapool,
            int newEquivalenceClassIndex)
    {
        // TODO Auto-generated method stub

    }
    /* (non-Javadoc)
     * @see org.eclipse.hyades.edit.datapool.IDatapoolListener#equivalenceClassChanged(org.eclipse.hyades.edit.datapool.IDatapool, int, java.lang.String)
     */
    public void equivalenceClassChanged(IDatapool datapool,
            int equivalenceClassIndex, String oldName)
    {
        // TODO Auto-generated method stub

    }
    /* (non-Javadoc)
     * @see org.eclipse.hyades.edit.datapool.IDatapoolListener#equivalenceClassChanged(org.eclipse.hyades.edit.datapool.IDatapool, int)
     */
    public void equivalenceClassChanged(IDatapool datapool,
            int equivalenceClassIndex)
    {
        // TODO Auto-generated method stub

    }
    /* (non-Javadoc)
     * @see org.eclipse.hyades.edit.datapool.IDatapoolListener#equivalenceClassMoved(org.eclipse.hyades.edit.datapool.IDatapool, int, int)
     */
    public void equivalenceClassMoved(IDatapool datapool,
            int sourceEquivalenceClassIndex, int targetEquivalenceClassIndex)
    {
        // TODO Auto-generated method stub

    }
    /* (non-Javadoc)
     * @see org.eclipse.hyades.edit.datapool.IDatapoolListener#equivalenceClassRemoved(org.eclipse.hyades.edit.datapool.IDatapool, int)
     */
    public void equivalenceClassRemoved(IDatapool datapool,
            int equivalenceClassIndex)
    {
        // TODO Auto-generated method stub

    }
    /* (non-Javadoc)
     * @see org.eclipse.hyades.edit.datapool.IDatapoolListener#equivalenceClassReordered(org.eclipse.hyades.edit.datapool.IDatapool, int)
     */
    public void equivalenceClassReordered(IDatapool datapool,
            int equivalenceClassIndex)
    {
        // TODO Auto-generated method stub

    }
    /* (non-Javadoc)
     * @see org.eclipse.hyades.edit.datapool.IDatapoolListener#recordAdded(org.eclipse.hyades.edit.datapool.IDatapool, int, int)
     */
    public void recordAdded(IDatapool datapool, int EquivClassIndex,
            int newRecordIndex)
    {
        // TODO Auto-generated method stub

    }
    /* (non-Javadoc)
     * @see org.eclipse.hyades.edit.datapool.IDatapoolListener#recordChanged(org.eclipse.hyades.edit.datapool.IDatapool, int, int)
     */
    public void recordChanged(IDatapool datapool, int EquivClassIndex,
            int recordIndex)
    {
        // TODO Auto-generated method stub

    }
    /* (non-Javadoc)
     * @see org.eclipse.hyades.edit.datapool.IDatapoolListener#recordMoved(org.eclipse.hyades.edit.datapool.IDatapool, int, int, int)
     */
    public void recordMoved(IDatapool datapool, int EquivClassIndex,
            int sourceRecordIndex, int targetRecordIndex)
    {
        // TODO Auto-generated method stub

    }
    /* (non-Javadoc)
     * @see org.eclipse.hyades.edit.datapool.IDatapoolListener#recordRemoved(org.eclipse.hyades.edit.datapool.IDatapool, int, int)
     */
    public void recordRemoved(IDatapool datapool, int EquivClassIndex,
            int recordIndex)
    {
        // TODO Auto-generated method stub

    }
    /* (non-Javadoc)
     * @see org.eclipse.hyades.edit.datapool.IDatapoolListener#save(org.eclipse.hyades.edit.datapool.IDatapool)
     */
    public void save(IDatapool datapool)
    {
        // TODO Auto-generated method stub

    }
    /* (non-Javadoc)
     * @see org.eclipse.hyades.edit.datapool.IDatapoolListener#variableAdded(org.eclipse.hyades.edit.datapool.IDatapool, int)
     */
    public void variableAdded(IDatapool datapool, int newVariableIndex)
    {

    }
    /* (non-Javadoc)
     * @see org.eclipse.hyades.edit.datapool.IDatapoolListener#variableChanged(org.eclipse.hyades.edit.datapool.IDatapool, int, java.lang.String)
     */
    public void variableChanged(IDatapool datapool, int variableIndex,
            String oldName)
    {
        // TODO Auto-generated method stub

    }
    /* (non-Javadoc)
     * @see org.eclipse.hyades.edit.datapool.IDatapoolListener#variableChanged(org.eclipse.hyades.edit.datapool.IDatapool, int)
     */
    public void variableChanged(IDatapool datapool, int variableIndex)
    {
        // TODO Auto-generated method stub

    }
    /* (non-Javadoc)
     * @see org.eclipse.hyades.edit.datapool.IDatapoolListener#variableMoved(org.eclipse.hyades.edit.datapool.IDatapool, int, int)
     */
    public void variableMoved(IDatapool datapool, int sourceVariableIndex,
            int targetVariableIndex)
    {
        // TODO Auto-generated method stub

    }
    /* (non-Javadoc)
     * @see org.eclipse.hyades.edit.datapool.IDatapoolListener#variableRemoved(org.eclipse.hyades.edit.datapool.IDatapool, int)
     */
    public void variableRemoved(IDatapool datapool, int variableIndex)
    {
        // TODO Auto-generated method stub

    }
}
