/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DeploymentForm.java,v 1.11 2005/03/02 23:41:34 bjiang Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.editor.form.util.NamedElementsSection;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.extension.DeploymentEditorExtension;
import org.eclipse.hyades.test.ui.internal.editor.form.util.DeploymentTestSuitesSection;
import org.eclipse.hyades.test.ui.internal.editor.util.DeploymentCompatibilityConverter;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.internal.util.ContextIds;
import org.eclipse.hyades.test.ui.util.TestUIUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.help.WorkbenchHelp;

/**
 * @author marcelop
 * @since 0.2.0
 * @author bjiang
 * @since 1.3
 */
public class DeploymentForm extends ConfigurableObjectOverviewForm
{	
	private int mapPageIndex;	
	private NamedElementsSection artifactsSection;
	private NamedElementsSection locationsSection;
	private DeploymentTestSuitesSection testSuitesSection;

	
	/**
	 * Constructor for DeploymentForm
	 * @param deploymentEditorExtension
	 * @param widgetFactory
	 */
	public DeploymentForm(DeploymentEditorExtension deploymentEditorExtension, WidgetFactory widgetFactory)
	{
		super(deploymentEditorExtension, widgetFactory);
		setHeadingText(TestUIPlugin.getString("W_DEPLOYMENT")); //$NON-NLS-1$
	}

	/**
	 * @see org.eclipse.update.ui.forms.internal.IForm#dispose()
	 */
	public void dispose()
	{
		if(artifactsSection != null)
		{
			artifactsSection.dispose();
			artifactsSection = null;
		}
		if(locationsSection != null)
		{
			locationsSection.dispose();
			locationsSection = null;
		}
		if(testSuitesSection != null)
		{
		    testSuitesSection.dispose();
		    testSuitesSection = null;
		}

		super.dispose();
	}
	
	/**
	 * Sets the index of the Locations page that is presented when the "more" button
	 * of the location section is pressed. 
	 * @param index
	 */
	public void setLocationPageIndex(int index)
	{
		mapPageIndex = index;
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.util.EditorForm#createControl()
	 */
	public Control createControl()
	{
		Control control = super.createControl();
		WorkbenchHelp.setHelp(getControl(), TestUIPlugin.getID() + ContextIds.DEPL_FORM);
		return control;
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.common.EditorForm#createEditorFormContents(org.eclipse.swt.widgets.Composite)
	 */
	protected void createEditorFormContents(Composite parent)
	{
		super.createEditorFormContents(parent);	
		
		artifactsSection = new NamedElementsSection(getBaseEditorExtension(), mapPageIndex);
		registerSection(artifactsSection);
		artifactsSection.createControl(getRightColumnContainer(), factory, TestUIPlugin.getString("W_ARTIFACTS"), TestUIPlugin.getString("EDT_DEP_ART_DSC"));

		locationsSection = new NamedElementsSection(getBaseEditorExtension(), mapPageIndex);
		registerSection(locationsSection);
		locationsSection.createControl(getRightColumnContainer(), factory,
			TestUIPlugin.getString("W_LOCS"), //$NON-NLS-1$
			TestUIPlugin.getString("EDT_DEP_LOC_DSC")); //$NON-NLS-1$
		
		testSuitesSection = new DeploymentTestSuitesSection();
		registerSection(testSuitesSection);
		testSuitesSection.createControl(getRightColumnContainer(), factory, TestUIPlugin.getString("W_TST_SUITE"), TestUIPlugin.getString("EDT_DEP_TSUITE_DSC"));
	}
	
	protected void setGeneralInfoSectionHelp(Control control)
	{
		//WorkbenchHelp.setHelp(((GeneralInfoSection)getGeneralInfoSection()).getFileText(), TestUIPlugin.getID() + ContextIds.DEPL_TEXT_FORM);
		WorkbenchHelp.setHelp(control, TestUIPlugin.getID() + ContextIds.DEPL_NAME_FORM);	
	}
	
	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.common.EditorForm#load()
	 */
	public void load()
	{
		super.load();
		
		boolean isOld = false;
		TPFDeployment deployment = (TPFDeployment)getDataObject();
		artifactsSection.initialize(getDataObject(), Common_TestprofilePackage.eINSTANCE.getTPFDeployment_Artifacts(), null);
		testSuitesSection.initialize(getDataObject(), Common_TestprofilePackage.eINSTANCE.getTPFDeployment_Artifacts(), null);
		if(!deployment.getLocations().isEmpty())
		{
			boolean toConvert = MessageDialog.openQuestion(Display.getCurrent().getActiveShell(), 
															TestUIPlugin.getString("DLG_UPGRADE_DEP"),  //$NON-NLS-1$
															TestUIPlugin.getString("DLG_UPGRADE_DSC")); //$NON-NLS-1$
			if(toConvert == true)
			{			
				try
				{
					DeploymentCompatibilityConverter.convert(deployment);
					getBaseEditorExtension().markDirty();
				}
				catch(Exception e)
				{
					e.printStackTrace();
				}						   						
			}
			else
			{
				isOld = true;
			}
		}
		
		if(isOld)
			locationsSection.initialize(getDataObject(), Common_TestprofilePackage.eINSTANCE.getTPFDeployment_Locations(), null);
		else		
			locationsSection.initialize(getDataObject(), Common_TestprofilePackage.eINSTANCE.getTPFDeployment_RefLocations(), null);
	}
	
	public void openLocationEditor(CFGLocation location)
	{
		Resource resource = ((EObject)location).eResource();
		TestUIUtil.openEditor(resource, TestUIExtension.LOCATION_EDITOR_PART_ID, false);
	}
}
