/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: LocationsForm.java,v 1.9 2005/02/16 22:22:05 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form;

import org.eclipse.hyades.models.common.configuration.CFGMachineConstraint;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.action.AddLocationAction;
import org.eclipse.hyades.test.ui.internal.action.OpenLocationAction;
import org.eclipse.hyades.test.ui.internal.editor.extension.DeploymentEditorExtension;
import org.eclipse.hyades.test.ui.internal.editor.form.util.DetailSection;
import org.eclipse.hyades.test.ui.editor.form.util.ExtensibleEObjectTreeSection;
import org.eclipse.hyades.test.ui.internal.editor.form.util.GeneralInfoSection;
import org.eclipse.hyades.test.ui.internal.editor.form.util.NodeGeneralInfoSection;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.model.ui.ChildrenSelectionAction;
import org.eclipse.hyades.test.ui.action.model.MoveFeatureChildrenDownAction;
import org.eclipse.hyades.test.ui.action.model.MoveFeatureChildrenUpAction;
import org.eclipse.hyades.test.ui.action.model.RemoveFeatureChildrenAction;
import org.eclipse.hyades.test.ui.internal.util.ContextIds;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.help.WorkbenchHelp;

/**
 * This is the locations tab of the deployment editor.
 * 
 * @author marcelop
 * @since 0.2.0
 * @author	bjiang
 * @since	1.3
 * @deprecated replaced by org.eclipse.hyades.test.ui.internal.editor.form.ArtifactLocationMapForm.
 * @since 3.0
 */
public class LocationsForm
extends ConfigurableObjectOverviewForm implements ISelectionChangedListener
{
	private int generalInfoPageIndex;
	
	private ExtensibleEObjectTreeSection locationsSection;
	private GeneralInfoSection generalInfoSection;
	private DetailSection detailSection;
	private AddLocationAction addLocationAction;
	private boolean firstActivation = true;
	private boolean editable;
	
	/**
	 * Constructor for LocationForm
	 * @param deploymentEditorExtension
	 * @param widgetFactory
	 */
	public LocationsForm(DeploymentEditorExtension deploymentEditorExtension, WidgetFactory widgetFactory)
	{
		super(deploymentEditorExtension, widgetFactory);
		setHeadingText(TestUIPlugin.getString("W_DEPLOYMENT")); //$NON-NLS-1$
	}

	/**
	 * @see org.eclipse.update.ui.forms.internal.IForm#dispose()
	 */
	public void dispose()
	{
		locationsSection.getTreeViewer().removeSelectionChangedListener(this);
		locationsSection.dispose();
		generalInfoSection.dispose();
		addLocationAction.dispose();
		
		super.dispose();
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.common.EditorForm#createEditorFormContents(org.eclipse.swt.widgets.Composite)
	 */
	protected void createEditorFormContents(Composite parent)
	{
		super.createEditorFormContents(parent);	

		generalInfoSection = new NodeGeneralInfoSection(this, true);
		generalInfoSection.setEditable(isEditable());
		registerSection(generalInfoSection);		
		Control control = generalInfoSection.createControl(getRightColumnContainer(), getWidgetFactory());
		GridData gridData = new GridData(GridData.FILL_BOTH | GridData.VERTICAL_ALIGN_BEGINNING);
		control.setLayoutData(gridData);		
		WorkbenchHelp.setHelp(control, TestUIPlugin.getID() + ContextIds.LOC_COMMON_FORM);
	}
	
	protected void addDetails(DetailSection detailSection)
	{
		detailSection.add(CFGMachineConstraint.class, new MachineDetailPage());
	}

	protected void createGeneralInfoSection(Composite parent) 
	{
		TPFDeployment deployment = (TPFDeployment)getDataObject();
		IAction[] buttonActions = createButtonActions();
		if(!deployment.getLocations().isEmpty())
		{
			locationsSection = new ExtensibleEObjectTreeSection(this, Common_TestprofilePackage.eINSTANCE.getTPFDeployment_Locations(), buttonActions);
			setEditable(false);
		}
		else
		{
			locationsSection = new ExtensibleEObjectTreeSection(this, Common_TestprofilePackage.eINSTANCE.getTPFDeployment_RefLocations(), buttonActions);
			setEditable(true);
		}
		registerSection(locationsSection);
		locationsSection.setHeaderText(TestUIPlugin.getString("W_LOCS")); //$NON-NLS-1$
		locationsSection.setCollapsable(true);
		Control control = locationsSection.createControl(parent, getWidgetFactory());
		control.setLayoutData(new GridData(GridData.FILL_BOTH | GridData.VERTICAL_ALIGN_BEGINNING));		
		WorkbenchHelp.setHelp(control, TestUIPlugin.getID() + ContextIds.LOC_LOC_FORM);								
		WorkbenchHelp.setHelp(locationsSection.getTreeViewer().getControl(), TestUIPlugin.getID() + ContextIds.LOC_LOCTREE_FORM);			
		
		for(int i = 0; i < buttonActions.length; i++)
		{
		    IAction action = buttonActions[i];
		    if(action != null)
		    {
		        if(action instanceof ChildrenSelectionAction)
		            ((ChildrenSelectionAction)action).setStructuredViewer(locationsSection.getTreeViewer());
		        else if(action instanceof OpenLocationAction)
		            ((OpenLocationAction)action).setStructuredViewer(locationsSection.getTreeViewer());
		    }
		}
	}
	
	/**
	 * Creates the actions of the buttons that the primary editor section will use. 
	 * @return
	 */
	protected IAction[] createButtonActions()
	{
		IAction[] buttonActions = new IAction[5];
		buttonActions[0] = addLocationAction = new AddLocationAction();
		buttonActions[1] = new RemoveFeatureChildrenAction(getDataObject(), Common_TestprofilePackage.eINSTANCE.getTPFDeployment_RefLocations(), false);	
		buttonActions[2] = new MoveFeatureChildrenUpAction(getDataObject(), Common_TestprofilePackage.eINSTANCE.getTPFDeployment_RefLocations());
		buttonActions[3] = new MoveFeatureChildrenDownAction(getDataObject(), Common_TestprofilePackage.eINSTANCE.getTPFDeployment_RefLocations());
		buttonActions[4] = new OpenLocationAction();		
		return buttonActions;
	}	
	
	public void setEditable(boolean isEditable)
	{
		this.editable = isEditable;
		if(locationsSection != null)
			locationsSection.setEditable(editable);
		if(generalInfoSection != null)
			generalInfoSection.setEditable(editable);
	}
	
	public boolean isEditable()
	{
		return this.editable;
	}
	
	protected void createRegisteredExtensionsSection(Composite parent)
	{
	}
	
	/**
	 * Sets the index of the Overview page that is presented when the "open" button
	 * of the location page is pressed. 
	 * @param index
	 */
	public void setGeneralInfoPageIndex(int index)
	{
		generalInfoPageIndex = index;
	}
	
	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.common.EditorForm#load()
	 */
	public void load()
	{
		TPFDeployment deployment = (TPFDeployment)getDataObject();
		addLocationAction.setDeployment(deployment);		

		locationsSection.getTreeViewer().removeSelectionChangedListener(this);
		locationsSection.setInput(deployment);
		locationsSection.getTreeViewer().addSelectionChangedListener(this);
	}
	
	/**
	 * @see org.eclipse.ui.part.ISetSelectionTarget#selectReveal(org.eclipse.jface.viewers.ISelection)
	 */
	public void selectReveal(ISelection selection)
	{
		locationsSection.selectReveal(selection);
	}
	
	/**
	 * @see org.eclipse.jface.viewers.ISelectionChangedListener#selectionChanged(org.eclipse.jface.viewers.SelectionChangedEvent)
	 */
	public void selectionChanged(SelectionChangedEvent event)
	{
		if(event.getSource() == locationsSection.getTreeViewer())
		{
			IStructuredSelection structuredSelection = (IStructuredSelection)getSelection();
			generalInfoSection.setInput(structuredSelection);
			UIUtil.getActiveWorkbenchPage().activate((IWorkbenchPart)getBaseEditorExtension().getHyadesEditorPart());
		}
	}
	
	public ISelection getSelection()
	{
		return locationsSection.getTreeViewer().getSelection();
	}
	
	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.common.EditorForm#activated()
	 */
	public boolean activated()
	{
		if(firstActivation)
		{
			firstActivation = false;
			locationsSection.setFocus();
		}
			
		return super.activated();
	}
}
