/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: MachineDetailPage.java,v 1.8 2005/02/16 22:22:05 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.help.WorkbenchHelp;

import org.eclipse.hyades.models.common.configuration.CFGMachineConstraint;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.util.DetailSection;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.util.ContextIds;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;

/**
 * @author marcelop
 * @since 0.3.0
 */
public class MachineDetailPage 
extends DetailSection.DetailPage implements ModifyListener
{
	private StyledText hostNameText;
	private CFGMachineConstraint machine;
	
	/**
	 * @see org.eclipse.hyades.ui.util.IDisposable#dispose()
	 */
	public void dispose()
	{
		machine = null;
	}

	/**
	 * @see org.eclipse.hyades.test.java.internal.junit.editor.DetailSection.DetailPage#createControl(org.eclipse.swt.widgets.Composite, org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory)
	 */
	public Control createControl(Composite parent, FormWidgetFactory factory)
	{
		WidgetFactory widgetFactory = getEditorForm().getWidgetFactory();
		Composite composite = widgetFactory.createComposite(parent);
		composite.setLayout(new GridLayout());
		composite.setLayoutData(GridDataUtil.createFill());

		widgetFactory.createLabel(composite, TestUIPlugin.getString("LBL_HOST_NME")); //$NON-NLS-1$
		hostNameText = widgetFactory.createStyledText(composite, SWT.FULL_SELECTION | SWT.SINGLE);
		hostNameText.setLayoutData(GridDataUtil.createHorizontalFill());
		hostNameText.addVerifyKeyListener(this);
		
		widgetFactory.paintBordersFor(composite);

		WorkbenchHelp.setHelp(hostNameText, TestUIPlugin.getID() + ContextIds.MACHINE_TEXT_PAGE);										
		WorkbenchHelp.setHelp(composite, TestUIPlugin.getID() + ContextIds.MACHINE_DET_PAGE);								
		
		return composite;
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.util.EditorSection#setInput(java.lang.Object)
	 */
	public void setInput(Object object)
	{
		machine = null;

		hostNameText.removeVerifyKeyListener(this);
		hostNameText.removeModifyListener(this);

		if(object instanceof IStructuredSelection)
		{
			IStructuredSelection structuredSelection = (IStructuredSelection)object;
			if(structuredSelection.size() == 1)
				object = structuredSelection.getFirstElement();
		}

		if(object instanceof CFGMachineConstraint)
		{
			machine = (CFGMachineConstraint)object;
			
			String value = machine.getHostname();
			if(value != null)
				hostNameText.setText(value);
			else
				hostNameText.setText(""); //$NON-NLS-1$

			hostNameText.setEditable(true);			
		}
		else
		{
			hostNameText.setText(""); //$NON-NLS-1$
		}
		
		hostNameText.addVerifyKeyListener(this);
		hostNameText.addModifyListener(this);
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.util.EditorSection#getInput()
	 */
	public Object getInput()
	{
		return machine;
	}

	/**
	 * @see org.eclipse.swt.events.ModifyListener#modifyText(org.eclipse.swt.events.ModifyEvent)
	 */
	public void modifyText(ModifyEvent e)
	{
		if(e.widget == hostNameText)
		{
			machine.setHostname(hostNameText.getText());
			getEditorForm().getBaseEditorExtension().markDirty();
		}
	}
}
