/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: EditableTablePart.java,v 1.5 2005/02/16 22:22:05 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form.base;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;

/**
 * @author marcelop
 * @since 
 */
public class EditableTablePart 
extends TablePart
{
	private boolean editable;

	class NameModifier implements ICellModifier
	{
		public boolean canModify(Object object, String property)
		{
			return true;
		}
		public void modify(Object object, String property, Object value)
		{
			entryModified(object, value.toString());
		}
		public Object getValue(Object object, String property)
		{
			return object.toString();
		}
	}
	/**
	 * Constructor for EditableTablePart.
	 * @param buttonLabels
	 */
	public EditableTablePart(String[] buttonLabels)
	{
		super(buttonLabels);
	}

	public boolean isEditable()
	{
		return editable;
	}

	public void setEditable(boolean editable)
	{
		this.editable = editable;
	}

	protected StructuredViewer createStructuredViewer(Composite parent, int style, FormWidgetFactory factory)
	{
		TableViewer tableViewer = (TableViewer)super.createStructuredViewer(parent, style, factory);
		if (editable)
		{
			Table table = tableViewer.getTable();
			CellEditor[] editors = new CellEditor[] { new ModifiedTextCellEditor(table)};
			String[] properties = { "name" };
			tableViewer.setCellEditors(editors);
			tableViewer.setCellModifier(new NameModifier());
			tableViewer.setColumnProperties(properties);
			table.addKeyListener(new KeyAdapter()
			{
				public void keyPressed(KeyEvent e)
				{
					if (e.keyCode == SWT.F2)
					{
						activateEditMode();
					}
				}
			});
		}
		return tableViewer;
	}

	protected void activateEditMode()
	{
		TableViewer viewer = getTableViewer();
		IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
		if (selection.size() == 1 && !viewer.isCellEditorActive())
		{
			viewer.editElement(selection.getFirstElement(), 0);
		}
	}

	protected void entryModified(Object entry, String value)
	{
	}
}
