/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: StructuredViewerPart.java,v 1.6 2005/03/15 14:52:11 dguilbaud Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form.base;

import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/**
 * @author marcelop
 * @since 0.2.0
 */
public abstract class StructuredViewerPart 
extends SharedPartWithButtons
{
	private StructuredViewer viewer;
	private Point minSize = null;

	public StructuredViewerPart(String[] buttonLabels)
	{
		super(buttonLabels);
	}

	public StructuredViewerPart(String[] buttonLabels,String[] toolTips)
	{
		super(buttonLabels,toolTips);
	}
	
	public StructuredViewer getViewer()
	{
		return viewer;
	}

	public Control getControl()
	{
		return viewer.getControl();
	}

	/*
	 * @see SharedPartWithButtons#createMainControl(Composite, int, FormWidgetFactory)
	 */
	protected void createMainControl(Composite parent, int style, int span, FormWidgetFactory factory)
	{

		viewer = createStructuredViewer(parent, style, factory);
		viewer.addSelectionChangedListener(new ISelectionChangedListener()
		{
			public void selectionChanged(SelectionChangedEvent e)
			{
				StructuredViewerPart.this.selectionChanged((IStructuredSelection)e.getSelection());
			}
		});
		viewer.addDoubleClickListener(new IDoubleClickListener()
		{
			public void doubleClick(DoubleClickEvent e)
			{
			    StructuredViewerPart.this.handleDoubleClick((IStructuredSelection)e.getSelection());
			}
		});
		
		Control control = viewer.getControl();
		if (factory != null)
		{
			factory.hookDeleteListener(control);
		}
		GridData gd = new GridData(GridData.FILL_BOTH);
		gd.horizontalSpan = span;
		control.setLayoutData(gd);
		applyMinimumSize();
	}

	public void setMinimumSize(int width, int height)
	{
		minSize = new Point(width, height);
		if (viewer != null)
			applyMinimumSize();
	}
	private void applyMinimumSize()
	{
		if (minSize != null)
		{
			GridData gd = (GridData)viewer.getControl().getLayoutData();
			gd.widthHint = minSize.x;
			gd.heightHint = minSize.y;
		}
	}

	protected void updateEnabledState()
	{
		getControl().setEnabled(isEnabled());
		super.updateEnabledState();
	}

	protected abstract StructuredViewer createStructuredViewer(Composite parent, int style, FormWidgetFactory factory);
	
	protected void selectionChanged(IStructuredSelection selection)
	{
	}
	protected void handleDoubleClick(IStructuredSelection selection)
	{
	}
}
