/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TreePart.java,v 1.6 2005/03/15 14:52:11 dguilbaud Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form.base;

import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class TreePart extends StructuredViewerPart
{

	/**
	 * Constructor for TreePart.
	 * @param buttonLabels
	 */
	public TreePart(String[] buttonLabels)
	{
		super(buttonLabels);
	}

	/**
	 * Constructor for TreePart.
	 * @param buttonLabels
	 */
	public TreePart(String[] buttonLabels,String [] toolTips)
	{
		super(buttonLabels,toolTips);
	}
	
	/*
	 * @see StructuredViewerPart#createStructuredViewer(Composite, FormWidgetFactory)
	 */
	protected StructuredViewer createStructuredViewer(Composite parent, int style, FormWidgetFactory factory)
	{
		style |= SWT.H_SCROLL | SWT.V_SCROLL;
		if (factory == null)
		{
			style |= SWT.BORDER;
		}
		else
		{
			style |= FormWidgetFactory.BORDER_STYLE;
		}
		TreeViewer treeViewer = new TreeViewer(parent, style);
		return treeViewer;
	}

	public TreeViewer getTreeViewer()
	{
		return (TreeViewer)getViewer();
	}
	
	/*
	 * @see SharedPartWithButtons#buttonSelected(int)
	 */
	protected void buttonSelected(Button button, int index)
	{
	}
}