/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: NamedElementLink.java,v 1.7 2005/02/16 22:22:06 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form.util;

import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.model.IWorkbenchAdapter;

import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.editor.form.base.IHyperlinkListener;
import org.eclipse.hyades.test.ui.internal.editor.form.base.SelectableFormLabel;
import org.eclipse.hyades.test.ui.internal.model.CMNNamedElementUtil;
import org.eclipse.hyades.ui.editor.IEditorExtension;

/**
 * @author marcelop
 * @since 0.2.0
 */
public class NamedElementLink
implements IHyperlinkListener, CMNNamedElementUtil.NameChangeObserver, DisposeListener
{
	private IEditorExtension editorExtension;
	private int destinationPage;

	private CMNNamedElementUtil.NameChangeAdapter adapter;
	private SelectableFormLabel hyperlink;
	private String prefix; 
	
	/**
	 * Constructor for NamedElementLink
	 */
	public NamedElementLink(IEditorExtension editorExtension, int destinationPage)
	{
		this.editorExtension = editorExtension;
		this.destinationPage = destinationPage;
		prefix = ""; //$NON-NLS-1$
	}
	
	/**
	 * @see org.eclipse.swt.events.DisposeListener#widgetDisposed(org.eclipse.swt.events.DisposeEvent)
	 */
	public void widgetDisposed(DisposeEvent e)
	{
		if(hyperlink != null)
		{
			CMNNamedElement namedElement = (CMNNamedElement)hyperlink.getData();
			namedElement.eAdapters().remove(adapter);
			
			adapter.dispose();
			adapter = null;
			hyperlink.removeDisposeListener(this);
			hyperlink.setData(null);
			hyperlink = null;
		}
		editorExtension = null;
	}

	/**
	 * Sets the hover status line message head.
	 * @param head
	 */
	public void setHoverMessagePrefix(String head)
	{
		if(head == null)
			this.prefix = ""; //$NON-NLS-1$
		else
			this.prefix = head + " # "; //$NON-NLS-1$
	}
	
	public void create(FormWidgetFactory widgetFactory, Composite parent, CMNNamedElement namedElement)
	{
		if(hyperlink != null)
			return;
			
		ImageDescriptor imageDescriptor = null;
		IWorkbenchAdapter workbenchAdapter = (IWorkbenchAdapter)namedElement.getAdapter(IWorkbenchAdapter.class);
		if((workbenchAdapter != null))
			imageDescriptor = workbenchAdapter.getImageDescriptor(namedElement);
		if(imageDescriptor == null)
			imageDescriptor = TestUIImages.INSTANCE.getImageDescriptor(TestUIImages.IMG_DEFAULT);

		Label imageLabel = widgetFactory.createLabel(parent, ""); //$NON-NLS-1$
		imageLabel.setImage(imageDescriptor.createImage());

		String name = namedElement.getName();
		if(name == null)
			name = ""; //$NON-NLS-1$
		String tooltip = name;

		hyperlink =	widgetFactory.createSelectableLabel(parent, name);
		widgetFactory.turnIntoHyperlink(hyperlink, this);
		hyperlink.addDisposeListener(this);
		hyperlink.setToolTipText(tooltip);
		hyperlink.setData(namedElement);
		
		adapter = new CMNNamedElementUtil.NameChangeAdapter(this);
		namedElement.eAdapters().add(adapter);
	}
	
	/**
	 * @see org.eclipse.update.ui.forms.internal.IHyperlinkListener#linkActivated(org.eclipse.swt.widgets.Control)
	 */
	public void linkActivated(Control linkLabel)
	{
		editorExtension.setSelection(new StructuredSelection(linkLabel.getData()));
		editorExtension.getHyadesEditorPart().setActivePage(destinationPage);
	}

	/**
	 * @see org.eclipse.update.ui.forms.internal.IHyperlinkListener#linkEntered(org.eclipse.swt.widgets.Control)
	 */
	public void linkEntered(Control linkLabel)
	{
		IActionBars actionBars = editorExtension.getHyadesEditorPart().getEditorPart().getEditorSite().getActionBars();
		IStatusLineManager manager = actionBars.getStatusLineManager();
		if (manager != null)
			manager.setMessage(prefix + ((SelectableFormLabel)linkLabel).getText());
	}

	/**
	 * @see org.eclipse.update.ui.forms.internal.IHyperlinkListener#linkExited(org.eclipse.swt.widgets.Control)
	 */
	public void linkExited(Control linkLabel)
	{
		IActionBars actionBars = editorExtension.getHyadesEditorPart().getEditorPart().getEditorSite().getActionBars();
		IStatusLineManager manager = actionBars.getStatusLineManager();
		manager.setMessage(""); //$NON-NLS-1$
	}
	
	/**
	 * @see org.eclipse.hyades.test.ui.internal.model.CMNNamedElementUtil.NameChangeObserver#update(org.eclipse.hyades.models.common.common.CMNNamedElement, java.lang.String)
	 */
	public void update(CMNNamedElement namedElement, String oldName)
	{
		String name = namedElement.getName();
		if(name == null)
			name = ""; //$NON-NLS-1$
			
		hyperlink.setText(name);
		hyperlink.setToolTipText(name);
		hyperlink.pack();
		hyperlink.getParent().pack(true);
	}
}
