/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: RegisteredExtensionsSection.java,v 1.6 2005/02/16 22:22:06 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.editor.form.util;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.hyades.test.ui.internal.editor.extension.IExtensibleEditorExtension;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormSection;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;

/**
 * This class implements a section for registered extensions in an editor of {@link org.eclipse.hyades.test.ui.internal.editor.extension.IExtensibleEditorExtension}.
 * 
 * @author bjiang
 * @since  1.3
 */
public class RegisteredExtensionsSection extends FormSection implements IDisposable 
{
	private IExtensibleEditorExtension editorExtension;
	private IConfigurationElement[] extensionElements;

	private FormWidgetFactory factory;
	private Composite hyperlinksParent;
	
	public RegisteredExtensionsSection(IExtensibleEditorExtension editorExtension, IConfigurationElement[] extElements)
	{
		this.editorExtension = editorExtension;
		this.extensionElements = extElements;
		setCollapsable(true);
	}
	
	/**
	 * @see org.eclipse.update.ui.forms.internal.FormSection#dispose()
	 */
	public void dispose()
	{
		editorExtension = null;
		factory = null;
		hyperlinksParent = null;
		
		super.dispose();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.base.FormSection#createClient(org.eclipse.swt.widgets.Composite, org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory)
	 */
	public Composite createClient(Composite parent, FormWidgetFactory factory) 
	{
		this.factory = factory;
		
		Composite container = factory.createComposite(parent);
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 2;
		container.setLayout(gridLayout);
		container.setLayoutData(GridDataUtil.createFill());
				
		hyperlinksParent = factory.createComposite(container);
		gridLayout = new GridLayout();
		gridLayout.numColumns = 2;
		gridLayout.marginHeight = 0;
		gridLayout.marginWidth = 0;
		gridLayout.verticalSpacing = 2;
		hyperlinksParent.setLayout(gridLayout);
		hyperlinksParent.setLayoutData(GridDataUtil.createFill());
		hyperlinksParent.getAccessible().addAccessibleListener(this);
		
		createLinkedElements();
		
		return container;
	}
	
	private void createLinkedElements()
	{
		if(extensionElements == null || extensionElements.length == 0)
			return;
			
		for( int i = 0; i < extensionElements.length; i++ )
		{
			ExtensionElementLink link = new ExtensionElementLink(editorExtension);
			link.create(factory, hyperlinksParent, extensionElements[i]);
		}

		hyperlinksParent.pack(true);

		Composite parent = hyperlinksParent.getParent();
		parent.setSize(parent.computeSize(parent.getSize().x, SWT.DEFAULT));					
		parent.getParent().setSize(parent.getParent().computeSize(parent.getParent().getSize().x, SWT.DEFAULT));
	}

}
