/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: EventUtil.java,v 1.8 2005/02/16 22:22:06 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.model;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

import org.eclipse.hyades.test.ui.TestUIPlugin;

/**
 * @author marcelop
 * @since 0.3.0
 */
public class EventUtil
{
	public final static String TIME_FORMAT = "yyyy.MM.dd - hh:mm:ss a";
	public final static String DURATION_FORMAT = "HH:mm:ss:SSS";
	

	/**
	 * Returns the time given the timestamp used in the event.  If the timestamp
	 * is not valid this method returns an empty string.
	 * @param timestamp
	 * @return a not <code>null</code> String
	 */
	public static String getTime(long timestamp)
	{
		if(timestamp != 0)
		{
			try
			{
				DateFormat format = DateFormat.getDateTimeInstance(DateFormat.MEDIUM, DateFormat.FULL);
				return format.format(new Date(timestamp));
			}
			catch (RuntimeException e)
			{
				TestUIPlugin.logError(e);
			}
		}
		
		return ""; //$NON-NLS-1$	
	}

	/**
	 * @param timestamp
	 * @param endTimestamp
	 * @return
	 */
	public static String getDuration(long timestamp, long endTimestamp) {
		if(timestamp != 0 && endTimestamp != 0)
		{
			try
			{
				long duration = endTimestamp - timestamp;
				SimpleDateFormat format = new SimpleDateFormat(DURATION_FORMAT);
				// Must set the timezone of the DateFormat to GMT, b/c 
				// Date is relative to GMT (and the formatter will format
				// the duration to the default Timezone otherwise, thereby
				// addin gor subtracting hours from our duration.)
				format.setTimeZone(TimeZone.getTimeZone("GMT")); //$NON-NLS-1$
				return format.format(new Date(duration));
			}
			catch (RuntimeException e)
			{
				TestUIPlugin.logError(e);
			}
		}
		
		return ""; //$NON-NLS-1$	
	}
}
